/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.ui.chart.model.ArchiveSeries;
import org.eclipse.scada.ui.chart.model.CompositeArchiveQualitySeries;
import org.eclipse.scada.ui.chart.model.DataItemSeries;
import org.eclipse.scada.ui.chart.model.DataSeries;
import org.eclipse.scada.ui.chart.model.ScriptSeries;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.scada.ui.chart.viewer.ArchiveSeriesViewer;
import org.eclipse.scada.ui.chart.viewer.AxisLocator;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.CompositeArchiveQualityViewer;
import org.eclipse.scada.ui.chart.viewer.DataItemSeriesViewer;
import org.eclipse.scada.ui.chart.viewer.InputViewer;
import org.eclipse.scada.ui.chart.viewer.ScriptSeriesViewer;
import org.eclipse.scada.ui.chart.viewer.XAxisViewer;
import org.eclipse.scada.ui.chart.viewer.YAxisViewer;

public class InputManager {
    private final WritableList list;
    protected final DataBindingContext dbc;
    private IListChangeListener listener;
    private final Map<DataSeries, InputViewer> inputMap = new HashMap<DataSeries, InputViewer>();
    private final ChartViewer viewer;
    private final AxisLocator<XAxis, XAxisViewer> xLocator;
    private final AxisLocator<YAxis, YAxisViewer> yLocator;
    private final ResourceManager resourceManager;

    public InputManager(DataBindingContext dbc, ChartViewer viewer, ResourceManager resourceManager, AxisLocator<XAxis, XAxisViewer> xLocator, AxisLocator<YAxis, YAxisViewer> yLocator) {
        this.list = new WritableList(dbc.getValidationRealm());
        this.dbc = dbc;
        this.viewer = viewer;
        this.resourceManager = resourceManager;
        this.xLocator = xLocator;
        this.yLocator = yLocator;
        this.listener = new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                InputManager.this.handleListeChange(event.diff);
            }
        };
        this.list.addListChangeListener(this.listener);
    }

    protected void handleListeChange(ListDiff diff) {
        diff.accept(new ListDiffVisitor(){

            public void handleRemove(int index, Object element) {
                InputManager.this.handleRemove((DataSeries)element);
            }

            public void handleAdd(int index, Object element) {
                InputManager.this.handleAdd((DataSeries)element);
            }
        });
    }

    protected void handleAdd(DataSeries element) {
        if (element instanceof DataItemSeries) {
            this.addInput(element, new DataItemSeriesViewer(this.dbc, (DataItemSeries)element, this.viewer, this.resourceManager, this.xLocator, this.yLocator));
        } else if (element instanceof ArchiveSeries) {
            this.addInput(element, new ArchiveSeriesViewer(this.dbc, (ArchiveSeries)element, this.viewer, this.resourceManager, this.xLocator, this.yLocator));
        } else if (element instanceof ScriptSeries) {
            this.addInput(element, new ScriptSeriesViewer(this.dbc, (ScriptSeries)element, this.viewer, this.resourceManager, this.xLocator, this.yLocator));
        } else if (element instanceof CompositeArchiveQualitySeries) {
            this.addInput(element, new CompositeArchiveQualityViewer(this.dbc, (CompositeArchiveQualitySeries)element, this.viewer, this.resourceManager, this.xLocator, this.yLocator));
        }
    }

    protected void addInput(DataSeries element, InputViewer viewer) {
        InputViewer oldItem = this.inputMap.put(element, viewer);
        if (oldItem != null) {
            oldItem.dispose();
        }
    }

    protected void handleRemove(DataSeries element) {
        InputViewer value = this.inputMap.remove(element);
        if (value != null) {
            value.dispose();
        }
    }

    public void dispose() {
        this.list.removeListChangeListener(this.listener);
        for (InputViewer input : this.inputMap.values()) {
            input.dispose();
        }
        this.inputMap.clear();
    }

    public WritableList getList() {
        return this.list;
    }
}

