/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input.composite;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.render.AbstractDataSeriesRenderer;
import org.eclipse.scada.chart.swt.render.QualityRenderer;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.input.AbstractInput;
import org.eclipse.scada.ui.chart.viewer.input.ArchiveInput;
import org.eclipse.scada.ui.chart.viewer.input.composite.CompositeSource;
import org.eclipse.scada.ui.chart.viewer.input.composite.MergedSeries;
import org.eclipse.scada.ui.chart.viewer.input.composite.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeQualityInput
extends AbstractInput {
    private static final Logger logger = LoggerFactory.getLogger(CompositeQualityInput.class);
    private double threshold;
    private final IObservableList inputs;
    private IListChangeListener listener;
    private final MergedSeries data;
    private final AbstractDataSeriesRenderer renderer;
    private final ChartRenderer chartRenderer;
    private final Map<ArchiveInput, CompositeSource> sources = new HashMap<ArchiveInput, CompositeSource>();

    public CompositeQualityInput(ChartViewer viewer, ChartRenderer chartRenderer, Realm realm, XAxis xAxis, YAxis yAxis, IObservableList inputs) {
        this.inputs = inputs;
        this.chartRenderer = chartRenderer;
        this.data = new MergedSeries(this.sources, realm, xAxis, yAxis);
        this.listener = new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                CompositeQualityInput.this.handleDiff(event.diff);
            }
        };
        this.inputs.addListChangeListener(this.listener);
        this.handleDiff(Diffs.computeListDiff((List)Collections.EMPTY_LIST, (List)inputs));
        this.renderer = new QualityRenderer(chartRenderer, (SeriesData)this.data){

            protected boolean checkQuality(boolean hasData, Double value) {
                if (!hasData || value == null) {
                    return false;
                }
                return CompositeQualityInput.this.checkQuality(value);
            }
        };
        this.chartRenderer.addRenderer((Renderer)this.renderer);
        this.attachHover(viewer, xAxis);
    }

    protected boolean checkQuality(double value) {
        return value > this.threshold;
    }

    public RGB getColor() {
        return null;
    }

    @Override
    public void dispose() {
        this.chartRenderer.removeRenderer((Renderer)this.renderer);
        this.renderer.dispose();
        this.inputs.removeListChangeListener(this.listener);
        this.data.dispose();
        super.dispose();
    }

    protected void handleDiff(ListDiff diff) {
        diff.accept(new ListDiffVisitor(){

            public void handleRemove(int index, Object element) {
                CompositeQualityInput.this.handleRemove(element);
            }

            public void handleAdd(int index, Object element) {
                CompositeQualityInput.this.handleAdd(element);
            }
        });
    }

    private void handleRemove(Object o) {
        logger.debug("Remove: {}", o);
        CompositeSource source = this.sources.remove(o);
        if (source != null) {
            logger.debug("Disposing source");
            source.dispose();
        }
        this.performUpdate();
    }

    private void handleAdd(Object o) {
        if (!(o instanceof ArchiveInput)) {
            return;
        }
        ArchiveInput archiveInput = (ArchiveInput)o;
        CompositeSource source = new CompositeSource(this, archiveInput);
        this.sources.put(archiveInput, source);
        this.performUpdate();
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.renderer != null) {
            this.renderer.setVisible(visible);
        }
        super.setVisible(visible);
    }

    @Override
    public void setSelection(boolean state) {
    }

    @Override
    public boolean tick(long now) {
        return false;
    }

    @Override
    public String getState() {
        return MessageFormat.format(Messages.CompositeQualityInput_State_Format, this.sources.size());
    }

    @Override
    public Image getPreview(int width, int height) {
        return null;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public void performUpdate() {
        this.data.update();
    }

    @Override
    protected void setSelectedTimestamp(Calendar selectedTimestamp) {
        DataEntry value = this.data.getViewData().getEntries().lower(new DataEntry(selectedTimestamp.getTimeInMillis(), null));
        if (value == null) {
            super.setSelectedTimestamp(selectedTimestamp);
            this.setSelectedValue(null);
        } else {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(value.getTimestamp());
            super.setSelectedTimestamp(c);
            this.setSelectedValue(value.getValue());
        }
    }
}

