/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input.composite;

import org.eclipse.scada.chart.SeriesDataListener;
import org.eclipse.scada.chart.SeriesViewData;
import org.eclipse.scada.ui.chart.viewer.input.ArchiveInput;
import org.eclipse.scada.ui.chart.viewer.input.QuerySeriesData;
import org.eclipse.scada.ui.chart.viewer.input.composite.CompositeQualityInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSource {
    private static final Logger logger = LoggerFactory.getLogger(CompositeSource.class);
    private final SeriesDataListener listener = new SeriesDataListener(){

        public void dataUpdate(long startTimestamp, long endTimestamp) {
            CompositeSource.this.handleDataUpdate();
        }
    };
    private final QuerySeriesData data;
    private SeriesViewData viewData;
    private final CompositeQualityInput compositeQualityInput;

    public CompositeSource(CompositeQualityInput compositeQualityInput, ArchiveInput archiveInput) {
        this.compositeQualityInput = compositeQualityInput;
        this.data = archiveInput.getData();
        this.data.addListener(this.listener);
    }

    public void dispose() {
        this.data.removeListener(this.listener);
    }

    protected void handleDataUpdate() {
        logger.debug("Data update from: {}", (Object)this.data);
        this.viewData = this.data.getQualityData();
        this.compositeQualityInput.performUpdate();
    }

    public SeriesViewData getViewData() {
        return this.viewData;
    }
}

