/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.widgets.realtime;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.da.ui.widgets.realtime.AttributePair;
import org.eclipse.scada.da.ui.widgets.realtime.ListEntry;
import org.eclipse.scada.ui.localization.Activator;

public class ItemCellLabelProvider
extends CellLabelProvider {
    private static DateFormat TIMESTAMP_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public void update(ViewerCell cell) {
        Object o = cell.getElement();
        if (o instanceof ListEntry) {
            this.updateListEntry((ListEntry)o, cell);
        } else if (o instanceof AttributePair) {
            this.updateAttributePair((AttributePair)o, cell);
        }
    }

    private void updateAttributePair(AttributePair attributePair, ViewerCell cell) {
        switch (cell.getColumnIndex()) {
            case 0: {
                cell.setText(attributePair.key);
                break;
            }
            case 2: {
                if (attributePair.value == null) break;
                cell.setText(attributePair.value.getType().name());
                break;
            }
            case 3: {
                if (attributePair.value == null) break;
                cell.setText(attributePair.value.asString("<null>"));
                break;
            }
        }
    }

    private void updateListEntry(ListEntry listEntry, ViewerCell cell) {
        cell.setFont(listEntry.getFont());
        cell.setForeground(listEntry.getForeground());
        cell.setBackground(listEntry.getBackground());
        switch (cell.getColumnIndex()) {
            case 0: {
                cell.setImage(listEntry.getImage());
                cell.setText(listEntry.getDataItem().getItem().getId());
                break;
            }
            case 1: {
                if (listEntry.getSubscriptionError() != null) {
                    cell.setText(String.format("%s (%s)", listEntry.getSubscriptionState(), listEntry.getSubscriptionError().getMessage()));
                    break;
                }
                cell.setText(listEntry.getSubscriptionState().name());
                break;
            }
            case 2: {
                if (listEntry.getValue() == null) break;
                cell.setText(listEntry.getValue().getType().name());
                break;
            }
            case 3: {
                if (listEntry.getValue() == null) break;
                cell.setText(listEntry.getValue().asString("<null>"));
                break;
            }
            case 4: {
                if (listEntry.getItemValue() == null) break;
                Calendar timestamp = listEntry.getItemValue().getTimestamp();
                if (timestamp != null) {
                    cell.setText(this.formatTimestamp(timestamp));
                    break;
                }
                cell.setText(null);
                break;
            }
        }
    }

    private String formatTimestamp(Calendar timestamp) {
        if (timestamp == null) {
            return null;
        }
        Calendar c = (Calendar)timestamp.clone();
        TimeZone tz = Activator.getTimeZone();
        if (tz != null) {
            c.setTimeZone(tz);
        }
        return TIMESTAMP_DATE_FORMAT.format(c.getTime());
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }
}

