/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor.forms.common.level;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ca.ui.editor.forms.common.ConfigurationFormToolkit;
import org.eclipse.scada.ca.ui.editor.forms.common.StandardConfigurationForm;
import org.eclipse.scada.ca.ui.editor.input.ConfigurationEditorInput;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class LevelEditorForm
extends StandardConfigurationForm {
    private static final String[] COMMON_PREFIXES = new String[]{"min", "lowlow", "low", "heigh", "heighheigh", "max"};

    @Override
    protected String getTitle(ConfigurationEditorInput input) {
        return String.format("Eclipse SCADA Level - %s: %s", input.getFactoryId(), input.getConfigurationId());
    }

    @Override
    protected void populateFormContent(ConfigurationFormToolkit toolkit, ScrolledForm form, ConfigurationEditorInput input) {
        Composite sectionClient = toolkit.createStandardSection(form.getBody(), "Level Information");
        toolkit.createStandardText(sectionClient, "preset", "Preset", "Preset value", (IObservableMap)input.getDataMap(), Double.class);
        toolkit.createStandardCheckbox(sectionClient, "includedOk", "If the value is equal to the preset the value is ok", (IObservableMap)input.getDataMap(), String.class);
        toolkit.createStandardCheckbox(sectionClient, "lowerOk", "If the value is lower than the preset it is ok", (IObservableMap)input.getDataMap(), String.class);
        toolkit.createStandardCheckbox(sectionClient, "cap", "Limit the value to the preset (min or max)", (IObservableMap)input.getDataMap(), String.class);
        sectionClient = toolkit.createStandardSection(form.getBody(), "Monitor Information");
        toolkit.createStandardCheckbox(sectionClient, "active", "Active", (IObservableMap)input.getDataMap(), String.class);
        toolkit.createStandardCombo(sectionClient, "prefix", "Prefix", COMMON_PREFIXES, (IObservableMap)input.getDataMap(), (Object)String.class);
        toolkit.createStandardCombo(sectionClient, "severity", "Severity", Severity.values(), (IObservableMap)input.getDataMap(), String.class);
        toolkit.createStandardCheckbox(sectionClient, "requireAck", "Require acknowledge", (IObservableMap)input.getDataMap(), String.class);
        sectionClient = toolkit.createStandardSection(form.getBody(), "Source Information");
        toolkit.createStandardLinkText(sectionClient, "master.item", "master.id", "Master Item Id", "ID of the master item", input, null);
        toolkit.createStandardText(sectionClient, "handlerPriority", "Handler Priority", "The sort order for the master handler list", (IObservableMap)input.getDataMap(), Integer.class);
        toolkit.createInfoSection(form, input);
    }
}

