/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor.config;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.scada.ca.ui.editor.input.ConfigurationEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractConfigurationEditor
extends EditorPart {
    private IObservableValue dirtyValue;
    private final boolean nested;

    public AbstractConfigurationEditor(boolean nested) {
        this.nested = nested;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        ConfigurationEditorInput input = this.getEditorInput();
        input.performSave(monitor);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        if (this.dirtyValue == null) {
            return false;
        }
        Object value = this.dirtyValue.getValue();
        if (!(value instanceof Boolean)) {
            return false;
        }
        return (Boolean)value;
    }

    protected void setInput(IEditorInput input) {
        ConfigurationEditorInput configurationInput = (ConfigurationEditorInput)input;
        if (!this.nested) {
            configurationInput.performLoad((IProgressMonitor)new NullProgressMonitor());
        }
        this.dirtyValue = configurationInput.getDirtyValue();
        this.dirtyValue.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                AbstractConfigurationEditor.this.firePropertyChange(257);
            }
        });
        super.setInput(input);
    }

    public ConfigurationEditorInput getEditorInput() {
        return (ConfigurationEditorInput)super.getEditorInput();
    }

    public void updateEntry(String oldKey, String key, String value) {
        this.getEditorInput().updateEntry(oldKey, key, value);
    }

    public void insertEntry(String key, String value) {
        this.getEditorInput().insertEntry(key, value);
    }

    public void deleteEntry(String key) {
        this.getEditorInput().deleteEntry(key);
    }
}

