/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.connection.internal;

import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.hd.connection.provider.ConnectionService;
import org.eclipse.scada.hd.ui.connection.internal.QueryBufferBean;
import org.eclipse.scada.hd.ui.data.AbstractQueryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryWrapper {
    private static final Logger logger = LoggerFactory.getLogger(QueryWrapper.class);
    private final ConnectionService service;
    private final WritableSet queries = new WritableSet();

    public QueryWrapper(ConnectionService service) {
        this.service = service;
    }

    public ConnectionService getService() {
        return this.service;
    }

    public void dispose() {
        for (Object query : this.queries) {
            ((AbstractQueryBuffer)query).close();
        }
        this.queries.clear();
    }

    public IObservableSet getQueriesObservable() {
        return Observables.proxyObservableSet((IObservableSet)this.queries);
    }

    public void createQuery(String id) {
        logger.info("Create new query for: {}", (Object)id);
        QueryBufferBean query = new QueryBufferBean(this, id);
        this.queries.add((Object)query);
    }

    protected void fakeIt(QueryBufferBean query) {
        this.queries.setStale(true);
        this.queries.remove((Object)query);
        this.queries.add((Object)query);
        this.queries.setStale(false);
    }

    public void removeQuery(QueryBufferBean queryBufferBean) {
        this.queries.remove((Object)queryBufferBean);
        queryBufferBean.close();
    }
}

