/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers.windows;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.scada.sec.ui.providers.KeyProviderFactory;
import org.eclipse.scada.sec.ui.providers.windows.SunMSCAPIProvider;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.ui.statushandlers.StatusManager;

public class FactoryImpl
implements KeyProviderFactory {
    private final Set<String> names = new HashSet<String>();
    private Realm realm;
    private WritableList list;

    public FactoryImpl() {
        try {
            String[] tokens = System.getProperty("org.eclipse.scada.sec.ui.providers.windows.defaultStoreNames", "Windows-MY,Windows-ROOT").split("\\s*,\\s*");
            this.names.addAll(Arrays.asList(tokens));
        }
        catch (Exception exception) {
            this.names.clear();
            this.names.add("Windows-MY");
            this.names.add("Windows-ROOT");
        }
    }

    public void init(Realm realm) {
        this.realm = realm;
        this.list = new WritableList();
        for (String name : this.names) {
            try {
                this.list.add((Object)new SunMSCAPIProvider(this.realm, name));
            }
            catch (Exception e) {
                StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers.windows", (Throwable)e));
            }
        }
    }

    public void dispose() {
        for (Object o : this.list) {
            ((SunMSCAPIProvider)((Object)o)).dispose();
        }
        this.list.dispose();
    }

    public String toString() {
        return "SunMSCAPI";
    }

    public IObservableList getKeyProviders() {
        return this.list;
    }
}

