/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolContext {
    private static final Logger logger = LoggerFactory.getLogger(SymbolContext.class);
    private final SymbolController controller;

    public SymbolContext(SymbolController controller) {
        this.controller = controller;
    }

    public Properties getProperties() {
        return this.controller.getProperties();
    }

    public Map<String, String> getPropertiesAsMap() {
        HashMap<String, String> r = new HashMap<String, String>();
        for (Object key : Collections.list(this.controller.getProperties().propertyNames())) {
            r.put((String)key, this.controller.getProperties().getProperty((String)key));
        }
        return r;
    }

    public Object getElement(String name) {
        return this.controller.getElement(name);
    }

    public Object getProperty(String name) {
        return this.controller.getProperties().getProperty(name);
    }

    public Object getProperty(String name, String defaultValue) {
        return this.controller.getProperties().getProperty(name, defaultValue);
    }

    public void registerItem(String name, String itemId, String connectionId) {
        this.registerItem(name, itemId, connectionId, false, true);
    }

    public void registerItem(String name, String itemId, String connectionId, boolean ignoreSummary, boolean nullInvalid) {
        this.controller.registerItem(name, itemId, connectionId, ignoreSummary, nullInvalid);
    }

    public void unregisterItem(String name) {
        this.controller.unregisterItem(name);
    }

    public void startWrite(String connectionId, String itemId, Object value) throws InterruptedException {
        this.controller.startWrite(connectionId, itemId, Variant.valueOf((Object)value));
    }

    public void startWriteString(String connectionId, String itemId, String value) throws InterruptedException {
        this.controller.startWrite(connectionId, itemId, VariantEditor.toVariant((String)value));
    }

    public void startWriteAttributeString(String connectionId, String itemId, String key, String value) throws InterruptedException {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put(key, VariantEditor.toVariant((String)value));
        this.controller.startWriteAttributes(connectionId, itemId, attributes);
    }

    public void startWriteAttribute(String connectionId, String itemId, String key, Object value) throws InterruptedException {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put(key, Variant.valueOf((Object)value));
        this.controller.startWriteAttributes(connectionId, itemId, attributes);
    }

    public void startWriteAttributes(String connectionId, String itemId, Map<String, Variant> attributes) throws InterruptedException {
        this.controller.startWriteAttributes(connectionId, itemId, attributes);
    }

    public SymbolContext getParent() {
        return this.controller.getParentContext();
    }

    public SummaryInformation getSummary() {
        return this.controller.getSummaryInformation();
    }

    public void executeCommand(String commandId, Map<String, String> eventData) {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            Command command = commandService.getCommand(commandId);
            Parameterization[] parameterizations = new Parameterization[eventData.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : eventData.entrySet()) {
                parameterizations[i] = new Parameterization(command.getParameter(entry.getKey()), entry.getValue());
                ++i;
            }
            ParameterizedCommand parameterCommand = new ParameterizedCommand(command, parameterizations);
            handlerService.executeCommand(parameterCommand, null);
        }
        catch (Exception e) {
            logger.warn("Failed to execute command", (Throwable)e);
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.vi.ui.draw2d", (Throwable)e), 4);
        }
    }
}

