/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.primitives;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.scada.vi.model.Alignment;
import org.eclipse.scada.vi.model.BorderChild;
import org.eclipse.scada.vi.model.BorderContainer;
import org.eclipse.scada.vi.model.Primitive;
import org.eclipse.scada.vi.ui.draw2d.BasicViewElementFactory;
import org.eclipse.scada.vi.ui.draw2d.Controller;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;
import org.eclipse.scada.vi.ui.draw2d.primitives.BorderChildController;

public class BorderContainerController
implements Controller {
    private final Figure figure = new Layer();
    private BorderLayout layout;

    public BorderContainerController(SymbolController controller, BorderContainer element, BasicViewElementFactory factory) throws Exception {
        this.figure.setOpaque(false);
        this.layout = new BorderLayout();
        this.figure.setLayoutManager((LayoutManager)this.layout);
        this.layout.setHorizontalSpacing(element.getHorizontalSpacing());
        this.layout.setVerticalSpacing(element.getVerticalSpacing());
        for (BorderChild child : element.getChildren()) {
            Controller elementController = factory.create(controller, child.getElement());
            IFigure childFigure = elementController.getFigure();
            controller.addRawElement(child.getName(), new BorderChildController(childFigure));
            this.figure.add(childFigure, BorderContainerController.convert(child.getAlignment()));
        }
        controller.addElement((Primitive)element, this);
    }

    public static Object convert(Alignment alignment) {
        switch (alignment) {
            case BOTTOM: {
                return BorderLayout.BOTTOM;
            }
            case TOP: {
                return BorderLayout.TOP;
            }
            case CENTER: {
                return BorderLayout.CENTER;
            }
            case LEFT: {
                return BorderLayout.LEFT;
            }
            case RIGHT: {
                return BorderLayout.RIGHT;
            }
        }
        return null;
    }

    @Override
    public IFigure getFigure() {
        return this.figure;
    }
}

