/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.primitives;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.scada.vi.model.GridAlignment;
import org.eclipse.scada.vi.model.GridChild;
import org.eclipse.scada.vi.model.GridContainer;
import org.eclipse.scada.vi.model.Primitive;
import org.eclipse.scada.vi.ui.draw2d.BasicViewElementFactory;
import org.eclipse.scada.vi.ui.draw2d.Controller;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;

public class GridContainerController
implements Controller {
    private final Figure figure = new Figure();

    public GridContainerController(SymbolController controller, GridContainer element, BasicViewElementFactory factory) throws Exception {
        GridLayout gridLayout = new GridLayout(element.getColumns(), element.isEqualWidth());
        gridLayout.horizontalSpacing = element.getHorizontalSpacing();
        gridLayout.verticalSpacing = element.getVerticalSpacing();
        gridLayout.marginHeight = element.getMarginHeight();
        gridLayout.marginWidth = element.getMarginWidth();
        this.figure.setLayoutManager((LayoutManager)gridLayout);
        for (GridChild child : element.getChildren()) {
            Controller elementController = factory.create(controller, child.getElement());
            IFigure childFigure = elementController.getFigure();
            this.figure.add(childFigure, this.convert(child));
        }
        controller.addElement((Primitive)element, this);
    }

    private Object convert(GridChild child) {
        GridData gd = new GridData();
        gd.horizontalAlignment = this.convert(child.getHorizontalAlignment());
        gd.verticalAlignment = this.convert(child.getVerticalAlignment());
        gd.grabExcessHorizontalSpace = child.isGrabHorizontalSpace();
        gd.grabExcessVerticalSpace = child.isGrabVerticalSpace();
        gd.horizontalSpan = child.getSpanCols();
        gd.verticalSpan = child.getSpanRows();
        if (child.getWidthHint() != null) {
            gd.widthHint = child.getWidthHint();
        }
        if (child.getHeightHint() != null) {
            gd.heightHint = child.getHeightHint();
        }
        return gd;
    }

    private int convert(GridAlignment alignment) {
        switch (alignment) {
            case BEGINNING: {
                return 1;
            }
            case END: {
                return 3;
            }
            case CENTER: {
                return 2;
            }
            case FILL: {
                return 4;
            }
        }
        return 1;
    }

    @Override
    public IFigure getFigure() {
        return this.figure;
    }
}

