/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.primitives;

import org.eclipse.draw2d.PolylineShape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.vi.model.Line;
import org.eclipse.scada.vi.model.Position;
import org.eclipse.scada.vi.model.Primitive;
import org.eclipse.scada.vi.model.Shape;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;
import org.eclipse.scada.vi.ui.draw2d.primitives.ShapeController;

public class LineController
extends ShapeController {
    private final PolylineShape figure = new PolylineShape(){

        public void addNotify() {
            super.addNotify();
            LineController.this.start();
        }

        public void removeNotify() {
            LineController.this.stop();
            super.removeNotify();
        }
    };
    private PointList points;

    public LineController(SymbolController controller, Line element, ResourceManager manager) {
        super(controller, manager);
        PointList points = new PointList();
        for (Position pos : element.getPoints()) {
            PrecisionPoint p = new PrecisionPoint(pos.getX(), pos.getY());
            points.addPoint((Point)p);
        }
        this.setPoints(points);
        controller.addElement((Primitive)element, this);
        this.applyCommon((Shape)element);
    }

    public void setPoints(PointList points) {
        this.points = points;
        this.figure.setPoints(this.points);
    }

    public void setPointsString(String pointsString) {
        String[] points;
        PointList pointList = new PointList();
        String[] stringArray = points = pointsString.split("\\|");
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            String point = stringArray[n2];
            String[] toks = point.split(";");
            PrecisionPoint p = new PrecisionPoint(Double.parseDouble(toks[0]), Double.parseDouble(toks[1]));
            pointList.addPoint((Point)p);
            ++n2;
        }
        this.setPoints(pointList);
    }

    @Override
    public void setPreferredSize(Dimension size) {
        if (size == null) {
            super.setPreferredSize(this.points.getBounds().expand(10, 10).getSize());
        } else {
            super.setPreferredSize(size);
        }
    }

    @Override
    public void setAntialias(Boolean value) {
        this.setAntialias(value, true);
    }

    @Override
    public void setOpaque(Boolean flag) {
        this.setOpaque(flag, true);
    }

    protected PolylineShape getPropertyFigure() {
        return this.figure;
    }
}

