/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.primitives;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.scada.vi.ui.draw2d.primitives.ShapeController;

public class RectangleFigureExtension
extends Shape {
    private final ShapeController controller;

    public RectangleFigureExtension(ShapeController controller) {
        this.controller = controller;
    }

    protected void fillShape(Graphics graphics) {
        graphics.fillRectangle(this.getBounds());
    }

    protected void outlineShape(Graphics graphics) {
        float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
        int inset1 = (int)Math.floor(lineInset);
        int inset2 = (int)Math.ceil(lineInset);
        Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
        r.x += inset1;
        r.y += inset1;
        r.width -= inset1 + inset2;
        r.height -= inset1 + inset2;
        graphics.drawRectangle(r);
    }

    public void addNotify() {
        super.addNotify();
        this.controller.start();
    }

    public void removeNotify() {
        this.controller.stop();
        super.removeNotify();
    }
}

