/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.primitives;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScalableLayeredPane;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.vi.model.Primitive;
import org.eclipse.scada.vi.model.Symbol;
import org.eclipse.scada.vi.model.SymbolReference;
import org.eclipse.scada.vi.ui.draw2d.BasicViewElementFactory;
import org.eclipse.scada.vi.ui.draw2d.Controller;
import org.eclipse.scada.vi.ui.draw2d.FactoryContext;
import org.eclipse.scada.vi.ui.draw2d.Helper;
import org.eclipse.scada.vi.ui.draw2d.SymbolController;
import org.eclipse.scada.vi.ui.draw2d.loader.SymbolLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolReferenceController
implements Controller {
    private static final Logger logger = LoggerFactory.getLogger(SymbolReferenceController.class);
    private final LayeredPane figure;

    public SymbolReferenceController(SymbolController controller, SymbolReference symbolReference, BasicViewElementFactory factory, ResourceManager manager, FactoryContext factoryContext) {
        if (symbolReference.getZoom() != null) {
            this.figure = new ScalableLayeredPane();
            ((ScalableLayeredPane)this.figure).setScale(symbolReference.getZoom().doubleValue());
        } else {
            this.figure = new LayeredPane();
        }
        Layer layer = new Layer();
        layer.setLayoutManager((LayoutManager)new StackLayout());
        layer.setOpaque(false);
        this.figure.setOpaque(false);
        this.figure.add((IFigure)layer);
        try {
            SymbolLoader symbolLoader = factory.getRoot();
            HashMap<String, String> properties = new HashMap<String, String>(this.convert((EMap<String, String>)symbolReference.getProperties()));
            this.createProperties(controller, symbolReference, properties);
            SymbolController childController = new SymbolController(controller.getShell(), controller, symbolLoader, properties, controller.getScriptObjects(), factoryContext);
            Symbol symbol = symbolLoader.loadSymbol();
            Controller elementController = factory.create(childController, symbol.getRoot());
            IFigure rootFigure = elementController.getFigure();
            layer.add(rootFigure);
            RGB color = org.eclipse.scada.vi.ui.draw2d.primitives.Helper.makeColor(symbol.getBackgroundColor());
            if (color != null) {
                layer.setBackgroundColor(manager.createColor(color));
            }
            controller.addElement((Primitive)symbolReference, elementController);
        }
        catch (Exception e) {
            logger.warn("Failed to create symbol", (Throwable)e);
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.vi.ui.draw2d", (Throwable)e), 1);
            layer.add(Helper.createErrorFigure(e));
        }
    }

    private void createProperties(SymbolController controller, SymbolReference symbolReference, Map<String, String> currentProperties) throws Exception {
        controller.createProperties("JavaScript", symbolReference.getOnCreateProperties(), currentProperties);
    }

    @Override
    public IFigure getFigure() {
        return this.figure;
    }

    private Map<? extends String, ? extends String> convert(EMap<String, String> properties) {
        HashMap<String, String> p = new HashMap<String, String>();
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                p.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return p;
    }
}

