/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.information.details;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.ui.connection.information.details.DetailsTab;
import org.eclipse.scada.core.ui.connection.information.details.InterfacesTab;
import org.eclipse.scada.core.ui.connection.information.details.PrivilegeTab;
import org.eclipse.scada.core.ui.connection.information.details.PropertiesTab;
import org.eclipse.scada.core.ui.connection.information.details.StatisticsTab;
import org.eclipse.scada.ui.utils.SelectionHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;

public class DetailsView {
    private final TabFolder tabFolder;
    private final Set<DetailsTab> tabs = new LinkedHashSet<DetailsTab>();

    public DetailsView(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.tabs.add(new InterfacesTab());
        this.tabs.add(new StatisticsTab());
        this.tabs.add(new PrivilegeTab());
        this.tabs.add(new PropertiesTab());
        for (DetailsTab tab : this.tabs) {
            tab.createTab(this.tabFolder);
        }
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    public void setSelection(ISelection selection) {
        ConnectionService connectionService = (ConnectionService)SelectionHelper.first((ISelection)selection, ConnectionService.class);
        for (DetailsTab tab : this.tabs) {
            tab.setSelection(connectionService);
        }
    }
}

