/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.extra.part;

import java.util.HashMap;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToggleButton;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.dataitem.details.extra.part.AbstractBaseDraw2DDetailsPart;
import org.eclipse.scada.da.client.dataitem.details.extra.part.Messages;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;

public class BooleanAlarmDetails
extends AbstractBaseDraw2DDetailsPart {
    private CheckBox button;
    private ToggleButton trueButton;
    private ToggleButton falseButton;

    @Override
    protected IFigure createMain() {
        Figure rootFigure = new Figure();
        rootFigure.setLayoutManager((LayoutManager)new GridLayout(5, true));
        rootFigure.setBackgroundColor(ColorConstants.white);
        rootFigure.add((IFigure)this.makeHeader(), (Object)new GridData(1, 2, true, false, 5, 1));
        rootFigure.add((IFigure)new Figure());
        rootFigure.add((IFigure)new Label(Messages.BooleanAlarmDetails_trigger_alarm_if_value_is));
        this.trueButton = new ToggleButton("true");
        rootFigure.add((IFigure)this.trueButton, (Object)new GridData(2, 2, true, true));
        this.trueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                BooleanAlarmDetails.this.setReference(false);
            }
        });
        this.falseButton = new ToggleButton("false");
        rootFigure.add((IFigure)this.falseButton, (Object)new GridData(2, 2, true, true));
        this.falseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                BooleanAlarmDetails.this.setReference(true);
            }
        });
        rootFigure.add((IFigure)new Figure());
        return rootFigure;
    }

    private Figure makeHeader() {
        this.button = new CheckBox(Messages.BooleanAlarmDetails_active);
        this.button.getModel().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                BooleanAlarmDetails.this.setEnabled(BooleanAlarmDetails.this.button.getModel().isSelected());
            }
        });
        return this.button;
    }

    protected void setReference(boolean b) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("org.eclipse.scada.ae.monitor.bit.reference", Variant.valueOf((boolean)b));
        this.item.writeAtrtibutes(attributes, null, this.makeDisplayCallback());
    }

    private CallbackHandler makeDisplayCallback() {
        return new DisplayCallbackHandler(this.shell, "Configure Boolean Monitor", "Confirmation required for configuring boolean monitor");
    }

    protected void setEnabled(boolean selected) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put("org.eclipse.scada.ae.monitor.bit.active", Variant.valueOf((boolean)selected));
        this.item.writeAtrtibutes(attributes, null, this.makeDisplayCallback());
    }

    @Override
    protected void update() {
        super.update();
        if (this.value == null) {
            return;
        }
        Variant active = (Variant)this.value.getAttributes().get("org.eclipse.scada.ae.monitor.bit.active");
        if (active != null && active.asBoolean()) {
            this.button.getModel().setSelected(true);
        } else {
            this.button.getModel().setSelected(false);
        }
        Variant reference = (Variant)this.value.getAttributes().get("org.eclipse.scada.ae.monitor.bit.reference");
        if (reference != null && reference.asBoolean()) {
            this.trueButton.getModel().setSelected(false);
            this.falseButton.getModel().setSelected(true);
        } else {
            this.trueButton.getModel().setSelected(true);
            this.falseButton.getModel().setSelected(false);
        }
    }

    @Override
    protected boolean isAvailable() {
        return this.hasAttribute("org.eclipse.scada.ae.monitor.bit.reference");
    }
}

