/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.extra.part;

import java.util.EnumSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.core.ui.styles.StateStyler;
import org.eclipse.scada.core.ui.styles.StaticStateInformation;
import org.eclipse.scada.core.ui.styles.StyleBlinker;
import org.eclipse.scada.core.ui.styles.StyleHandler;
import org.eclipse.scada.da.client.dataitem.details.extra.part.AbstractBaseDraw2DDetailsPart;
import org.eclipse.scada.da.client.dataitem.details.extra.part.Messages;
import org.eclipse.scada.da.client.dataitem.details.extra.part.VariantEntryDialog;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class GenericLevelPresets
extends AbstractBaseDraw2DDetailsPart {
    private Triangle triHH;
    private Triangle triH;
    private Triangle triL;
    private Triangle triLL;
    private Label presetHH;
    private Label presetH;
    private Label presetL;
    private Label presetLL;
    private Label currentLabel;
    private RectangleFigure rectCeil;
    private RectangleFigure rectFloor;
    private Label presetCeil;
    private Label presetFloor;
    private LevelBlinker blinkerHH;
    private LevelBlinker blinkerCeil;
    private LevelBlinker blinkerH;
    private LevelBlinker blinkerL;
    private LevelBlinker blinkerLL;
    private LevelBlinker blinkerFloor;
    private StateStyler stylerHH;
    private StateStyler stylerCeil;
    private StateStyler stylerH;
    private StateStyler stylerL;
    private StateStyler stylerLL;
    private StateStyler stylerFloor;
    private static final Dimension TRI_DIMENSION = new Dimension(50, 50);
    private static final Dimension RECT_DIMENSION = new Dimension(50, 15);
    private ConnectionLayer connLayer;

    @Override
    protected IFigure createMain() {
        LayeredPane baseFigure = new LayeredPane();
        Layer rootFigure = new Layer();
        this.connLayer = new ConnectionLayer();
        this.connLayer.setAntialias(1);
        this.connLayer.setConnectionRouter(ConnectionRouter.NULL);
        baseFigure.add((IFigure)this.connLayer);
        baseFigure.add((IFigure)rootFigure);
        rootFigure.setLayoutManager((LayoutManager)new BorderLayout());
        rootFigure.setBackgroundColor(ColorConstants.white);
        rootFigure.add(this.createArrowFigure(), (Object)BorderLayout.RIGHT);
        rootFigure.add(this.createEntryGrid((Figure)this.connLayer), (Object)BorderLayout.CENTER);
        return baseFigure;
    }

    private IFigure createEntryGrid(Figure connLayer) {
        Figure figure = new Figure();
        figure.setLayoutManager((LayoutManager)new GridLayout(1, false));
        this.presetCeil = new Label("");
        figure.add((IFigure)this.presetCeil, (Object)new GridData(2, 4, true, true));
        this.presetHH = new Label("");
        figure.add((IFigure)this.presetHH, (Object)new GridData(2, 4, true, true));
        this.presetH = new Label("");
        figure.add((IFigure)this.presetH, (Object)new GridData(2, 4, true, true));
        this.currentLabel = new Label("");
        figure.add((IFigure)this.currentLabel, (Object)new GridData(2, 4, true, true));
        this.presetL = new Label("");
        figure.add((IFigure)this.presetL, (Object)new GridData(2, 4, true, true));
        this.presetLL = new Label("");
        figure.add((IFigure)this.presetLL, (Object)new GridData(2, 4, true, true));
        this.presetFloor = new Label("");
        figure.add((IFigure)this.presetFloor, (Object)new GridData(2, 4, true, true));
        this.createConnection(connLayer, this.presetCeil, (Figure)this.rectCeil);
        this.createConnection(connLayer, this.presetHH, (Figure)this.triHH);
        this.createConnection(connLayer, this.presetH, (Figure)this.triH);
        this.createConnection(connLayer, this.presetL, (Figure)this.triL);
        this.createConnection(connLayer, this.presetLL, (Figure)this.triLL);
        this.createConnection(connLayer, this.presetFloor, (Figure)this.rectFloor);
        this.blinkerCeil = new LevelBlinker((IFigure)this.rectCeil);
        this.blinkerHH = new LevelBlinker((IFigure)this.triHH);
        this.blinkerH = new LevelBlinker((IFigure)this.triH);
        this.blinkerL = new LevelBlinker((IFigure)this.triL);
        this.blinkerLL = new LevelBlinker((IFigure)this.triLL);
        this.blinkerFloor = new LevelBlinker((IFigure)this.rectFloor);
        this.stylerCeil = new StateStyler((StyleHandler)this.blinkerCeil);
        this.stylerHH = new StateStyler((StyleHandler)this.blinkerHH);
        this.stylerH = new StateStyler((StyleHandler)this.blinkerH);
        this.stylerL = new StateStyler((StyleHandler)this.blinkerL);
        this.stylerLL = new StateStyler((StyleHandler)this.blinkerLL);
        this.stylerFloor = new StateStyler((StyleHandler)this.blinkerFloor);
        return figure;
    }

    protected abstract String getMinTag();

    protected abstract String getMaxTag();

    protected abstract String getHighHighTag();

    protected abstract String getHighTag();

    protected abstract String getLowTag();

    protected abstract String getLowLowTag();

    private void createConnection(Figure connLayer, Label label, Figure figure) {
        PolylineConnection c = new PolylineConnection();
        c.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)label));
        c.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)figure));
        c.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        connLayer.add((IFigure)c);
    }

    @Override
    public void dispose() {
        this.blinkerHH.dispose();
        this.blinkerH.dispose();
        this.blinkerLL.dispose();
        this.blinkerL.dispose();
        this.blinkerCeil.dispose();
        this.blinkerFloor.dispose();
        this.stylerCeil.dispose();
        this.stylerHH.dispose();
        this.stylerH.dispose();
        this.stylerL.dispose();
        this.stylerLL.dispose();
        this.stylerFloor.dispose();
        super.dispose();
    }

    private IFigure createArrowFigure() {
        RectangleFigure rect;
        Figure figure = new Figure();
        Figure innerFigure = new Figure();
        Figure outerFigure = new Figure();
        outerFigure.setLayoutManager((LayoutManager)new BorderLayout());
        figure.setLayoutManager((LayoutManager)new BorderLayout());
        innerFigure.setLayoutManager((LayoutManager)new BorderLayout());
        this.rectCeil = rect = new RectangleFigure();
        rect.setBackgroundColor(ColorConstants.black);
        rect.setSize(RECT_DIMENSION);
        rect.setLineWidth(3);
        rect.setCursor(Display.getDefault().getSystemCursor(21));
        outerFigure.add((IFigure)rect, (Object)BorderLayout.TOP);
        this.activate(this.getMaxTag(), (Shape)rect);
        this.triHH = this.createTri(figure, this.getHighHighTag(), BorderLayout.TOP, 1);
        this.triH = this.createTri(innerFigure, this.getHighTag(), BorderLayout.TOP, 1);
        this.triL = this.createTri(innerFigure, this.getLowTag(), BorderLayout.BOTTOM, 4);
        this.triLL = this.createTri(figure, this.getLowLowTag(), BorderLayout.BOTTOM, 4);
        this.rectFloor = rect = new RectangleFigure();
        rect.setBackgroundColor(ColorConstants.black);
        rect.setSize(RECT_DIMENSION);
        rect.setLineWidth(3);
        rect.setCursor(Display.getDefault().getSystemCursor(21));
        outerFigure.add((IFigure)rect, (Object)BorderLayout.BOTTOM);
        this.activate(this.getMinTag(), (Shape)rect);
        figure.add((IFigure)innerFigure, (Object)BorderLayout.CENTER);
        outerFigure.add((IFigure)figure, (Object)BorderLayout.CENTER);
        PolylineConnection c = new PolylineConnection();
        c.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)this.triH));
        c.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)this.triL));
        c.setLineWidth(5);
        innerFigure.add((IFigure)c);
        return outerFigure;
    }

    private Triangle createTri(Figure figure, String tag, Object constraint, int direction) {
        Triangle tri = new Triangle();
        tri.setDirection(direction);
        tri.setBackgroundColor(ColorConstants.black);
        tri.setSize(TRI_DIMENSION);
        tri.setLineWidth(3);
        tri.setCursor(Display.getDefault().getSystemCursor(21));
        figure.add((IFigure)tri, constraint);
        this.activate(tag, (Shape)tri);
        return tri;
    }

    private void activate(final String tag, Shape shape) {
        shape.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mouseReleased(MouseEvent me) {
                GenericLevelPresets.this.triggerAction(tag);
            }
        });
    }

    protected void toggle(String tag) {
        this.setActive(!this.isActive(tag), tag);
    }

    protected void triggerAction(String string) {
        try {
            Variant value = Variant.valueOf((Object)this.getPreset(string));
            value = !value.isNull() ? new VariantEntryDialog(this.shell, value).getValue() : new VariantEntryDialog(this.shell).getValue();
            if (value != null) {
                boolean active = value == null ? false : !value.isNull();
                this.setPreset(value, active, string);
            }
        }
        catch (Throwable e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.scada.da.client.dataitem.details.extra", Messages.GenericLevelPresets_ErrorMessage_Dialog, e));
        }
    }

    @Override
    protected void update() {
        super.update();
        if (this.value == null) {
            return;
        }
        this.setTri((Shape)this.rectCeil, this.getMaxTag());
        this.setTri((Shape)this.triHH, this.getHighHighTag());
        this.setTri((Shape)this.triH, this.getHighTag());
        this.setTri((Shape)this.triL, this.getLowTag());
        this.setTri((Shape)this.triLL, this.getLowLowTag());
        this.setTri((Shape)this.rectFloor, this.getMinTag());
        this.setStyle(this.stylerCeil, this.getMaxTag());
        this.setStyle(this.stylerHH, this.getHighHighTag());
        this.setStyle(this.stylerH, this.getHighTag());
        this.setStyle(this.stylerL, this.getLowTag());
        this.setStyle(this.stylerLL, this.getLowLowTag());
        this.setStyle(this.stylerFloor, this.getMinTag());
        this.setLabel(this.presetCeil, this.getMaxTag());
        this.setLabel(this.presetHH, this.getHighHighTag());
        this.setLabel(this.presetH, this.getHighTag());
        this.setLabel(this.presetL, this.getLowTag());
        this.setLabel(this.presetLL, this.getLowLowTag());
        this.setLabel(this.presetFloor, this.getMinTag());
        if (this.isCapped()) {
            this.currentLabel.setText(String.format(Messages.GenericLevelPresets_original_value_was, this.value.getValue(), this.getOriginalValue()));
        } else {
            this.currentLabel.setText("" + this.value.getValue());
        }
    }

    private void setStyle(StateStyler styler, String tag) {
        EnumSet<StateInformation.State> states = EnumSet.noneOf(StateInformation.State.class);
        if (this.isAlarm(tag)) {
            states.add(StateInformation.State.ALARM);
        }
        if (this.isWarning(tag)) {
            states.add(StateInformation.State.WARNING);
        }
        if (this.isAckRequired(tag, "warning")) {
            states.add(StateInformation.State.WARNING_ACK);
        }
        if (this.isAckRequired(tag, "alarm")) {
            states.add(StateInformation.State.ALARM_ACK);
        }
        if (this.isAckRequired(tag, "error")) {
            states.add(StateInformation.State.ERROR_ACK);
        }
        if (this.isUnsafe(tag)) {
            states.add(StateInformation.State.DISCONNECTED);
        }
        if (this.isError(tag)) {
            states.add(StateInformation.State.ERROR);
        }
        styler.style((StateInformation)new StaticStateInformation(states));
    }

    private void setLabel(Label preset, String string) {
        Number num = this.getPreset(string);
        if (num != null) {
            preset.setText(String.format(Messages.LevelPresets_NumFormat, num.toString()));
        } else {
            preset.setText(Messages.LevelPresets_EmtyNum);
        }
    }

    private void setTri(Shape tri, String string) {
        tri.setOutline(this.isActive(string));
    }

    protected abstract void setPreset(Variant var1, boolean var2, String var3);

    protected abstract void setActive(boolean var1, String var2);

    protected abstract boolean isError(String var1);

    protected abstract boolean isWarning(String var1);

    protected abstract boolean isAlarm(String var1);

    protected abstract boolean isAckRequired(String var1, String var2);

    protected abstract Number getPreset(String var1);

    protected abstract boolean isCapped();

    protected abstract Variant getOriginalValue();

    protected abstract boolean isActive(String var1);

    protected abstract boolean isUnsafe(String var1);

    protected DisplayCallbackHandler makeDisplayCallback() {
        return new DisplayCallbackHandler(this.shell, "Configure Level Monitors", "Confirmation required for configuring level monitors");
    }

    private class LevelBlinker
    extends StyleBlinker {
        private final IFigure figure;

        public LevelBlinker(IFigure figure) {
            this.figure = figure;
        }

        public void update(StyleBlinker.CurrentStyle currentStyle) {
            this.figure.setForegroundColor(currentStyle.foreground);
            this.figure.setBackgroundColor(currentStyle.background);
            this.figure.setFont(currentStyle.font);
        }
    }
}

