/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.extra.part;

import java.util.HashMap;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.dataitem.details.extra.part.GenericLevelPresets;
import org.eclipse.scada.sec.callback.CallbackHandler;

public class RemoteLevelPresets
extends GenericLevelPresets {
    @Override
    protected boolean isUnsafe(String string) {
        return false;
    }

    @Override
    protected boolean isActive(String string) {
        return this.getBooleanAttribute(String.format("remote.level.%s.active", string));
    }

    @Override
    protected Number getPreset(String string) {
        return this.getNumberAttribute(String.format("remote.level.%s.preset", string), null);
    }

    @Override
    protected boolean isCapped() {
        return this.hasAttribute("remote.level.original.value");
    }

    @Override
    protected Variant getOriginalValue() {
        return (Variant)this.value.getAttributes().get("remote.level.original.value");
    }

    @Override
    protected boolean isAlarm(String string) {
        return this.getBooleanAttribute(String.format("remote.level.%s.alarm", string));
    }

    @Override
    protected boolean isWarning(String string) {
        return this.getBooleanAttribute(String.format("remote.level.%s.warning", string));
    }

    @Override
    protected boolean isAckRequired(String string, String severity) {
        return this.getBooleanAttribute(String.format("remote.level.%s.%s.ackRequired", string, severity));
    }

    @Override
    protected boolean isError(String string) {
        return this.getBooleanAttribute(String.format("remote.level.%s.error", string));
    }

    @Override
    protected void setPreset(Variant value, boolean active, String tag) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(2);
        attributes.put(String.format("remote.level.%s.preset", tag), value);
        attributes.put(String.format("remote.level.%s.active", tag), active ? Variant.TRUE : Variant.FALSE);
        this.item.writeAtrtibutes(attributes, null, (CallbackHandler)this.makeDisplayCallback());
    }

    @Override
    protected void setActive(boolean state, String tag) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put(String.format("remote.level.%s.active", tag), state ? Variant.TRUE : Variant.FALSE);
        this.item.writeAtrtibutes(attributes, null, (CallbackHandler)this.makeDisplayCallback());
    }

    @Override
    protected boolean isAvailable() {
        return this.hasAttribute("remote.level.high.alarm") || this.hasAttribute("remote.level.low.alarm") || this.hasAttribute("remote.level.highhigh.alarm") || this.hasAttribute("remote.level.lowlow.alarm");
    }

    @Override
    protected String getMinTag() {
        return "floor";
    }

    @Override
    protected String getMaxTag() {
        return "ceil";
    }

    @Override
    protected String getHighHighTag() {
        return "highhigh";
    }

    @Override
    protected String getHighTag() {
        return "high";
    }

    @Override
    protected String getLowTag() {
        return "low";
    }

    @Override
    protected String getLowLowTag() {
        return "lowlow";
    }
}

