/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.importer.wizard;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.ca.ui.importer.wizard.Messages;
import org.eclipse.scada.ca.utils.DiffController;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;

public class IgnorePage
extends WizardPage {
    private final DiffController mergeController;
    private TableViewer factoriesViewer;
    private TreeViewer fieldsViewer;

    public IgnorePage(DiffController mergeController) {
        super("ignorePage");
        this.setTitle(Messages.IgnorePage_Title);
        this.mergeController = mergeController;
    }

    public void createControl(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new FillLayout());
        TabFolder folder = new TabFolder(wrapper, 128);
        TabItem item = new TabItem(folder, 0);
        item.setText(Messages.IgnorePage_TabItem_Factories_Text);
        item.setControl(this.createFactoriesTab((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(Messages.IgnorePage_TabItem_Fields_Text);
        item.setControl(this.createFieldsTab((Composite)folder));
        this.setControl((Control)wrapper);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            Object[] data = this.mergeController.makeKnownFactories().toArray();
            this.factoriesViewer.setInput((Object)data);
            Set factories = this.mergeController.getIgnoreFactories();
            TableItem[] tableItemArray = this.factoriesViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.setChecked(factories.contains(item.getData()));
                ++n2;
            }
            this.fieldsViewer.setInput((Object)this.mergeController.getIgnoreFields());
        }
    }

    private Control createFieldsTab(Composite parent) {
        this.fieldsViewer = new TreeViewer(parent);
        this.fieldsViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public boolean hasChildren(Object element) {
                Object[] childs = this.getChildren(element);
                if (childs == null) {
                    return false;
                }
                return childs.length > 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Map) {
                    return ((Map)parentElement).entrySet().toArray();
                }
                if (parentElement instanceof Map.Entry) {
                    return ((Collection)((Map.Entry)parentElement).getValue()).toArray();
                }
                return null;
            }
        });
        this.fieldsViewer.setInput((Object)this.mergeController.getIgnoreFields());
        this.fieldsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Map.Entry) {
                    return String.format("%s", ((Map.Entry)element).getKey());
                }
                return String.format("%s", element);
            }
        });
        this.fieldsViewer.setAutoExpandLevel(-1);
        return this.fieldsViewer.getControl();
    }

    private Control createFactoriesTab(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(1, true));
        this.factoriesViewer = new TableViewer(wrapper, 2848);
        this.factoriesViewer.setComparator(new ViewerComparator());
        this.factoriesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.factoriesViewer.getControl().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IgnorePage.this.mergeController.setIgnoreFactories(IgnorePage.this.gatherIgnoredFactories());
            }
        });
        this.factoriesViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonBar = new Composite(wrapper, 0);
        buttonBar.setLayoutData((Object)new GridData(4, 4, true, false));
        RowLayout layout = new RowLayout(256);
        layout.wrap = false;
        buttonBar.setLayout((Layout)layout);
        Button selectButton = new Button(buttonBar, 8);
        selectButton.setText(Messages.IgnorePage_SelectAll_Text);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IgnorePage.this.setFieldSelection(true);
            }
        });
        Button deselectButton = new Button(buttonBar, 8);
        deselectButton.setText(Messages.IgnorePage_DeselectAll_Text);
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IgnorePage.this.setFieldSelection(false);
            }
        });
        return wrapper;
    }

    protected void setFieldSelection(boolean state) {
        TableItem[] tableItemArray = this.factoriesViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(state);
            ++n2;
        }
    }

    protected Set<String> gatherIgnoredFactories() {
        HashSet<String> result = new HashSet<String>();
        TableItem[] tableItemArray = this.factoriesViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                String data = (String)item.getData();
                result.add(data);
            }
            ++n2;
        }
        return result;
    }
}

