/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.configuration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.ui.chart.configuration.Messages;
import org.eclipse.scada.ui.chart.model.ArchiveSeries;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.ChartFactory;
import org.eclipse.scada.ui.chart.model.CompositeArchiveQualitySeries;
import org.eclipse.scada.ui.chart.model.DataItemSeries;
import org.eclipse.scada.ui.chart.model.IdItem;
import org.eclipse.scada.ui.chart.model.ItemDataSeries;
import org.eclipse.scada.ui.chart.model.UriItem;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.swt.graphics.RGB;

public class Charts {
    private static RGB[] DEFAULT_COLORS = new RGB[]{new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(0, 255, 255), new RGB(255, 194, 0), new RGB(255, 0, 255), new RGB(0, 255, 255)};

    public static Chart makeDefaultConfiguration() {
        Chart configuration = ChartFactory.eINSTANCE.createChart();
        YAxis y = ChartFactory.eINSTANCE.createYAxis();
        y.setLabel(Messages.Charts_Label_Values);
        configuration.getLeft().add((Object)y);
        XAxis x = ChartFactory.eINSTANCE.createXAxis();
        x.setLabel(Messages.Charts_Label_Time);
        x.setMinimum(System.currentTimeMillis());
        x.setMaximum(System.currentTimeMillis() + 900000L);
        configuration.getBottom().add((Object)x);
        configuration.getSelectedXAxis().add((Object)x);
        configuration.getSelectedYAxis().add((Object)y);
        configuration.setTimeRulerAxis(x);
        configuration.getControllers().add((Object)ChartFactory.eINSTANCE.createMouseController());
        return configuration;
    }

    public static RGB nextFreeColor(Chart configuration) {
        return DEFAULT_COLORS[configuration.getInputs().size() % DEFAULT_COLORS.length];
    }

    public static void addItem(Chart chart, org.eclipse.scada.hd.ui.connection.data.Item item) {
        YAxis y;
        XAxis x = chart.getTimeRulerAxis();
        if (x == null) {
            return;
        }
        try {
            y = (YAxis)chart.getSelectedYAxis().get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
        IdItem itemRef = null;
        switch (item.getType()) {
            case ID: {
                itemRef = ChartFactory.eINSTANCE.createIdItem();
                itemRef.setItemId(item.getId());
                itemRef.setConnectionId(item.getConnectionString());
                break;
            }
            case URI: {
                itemRef = ChartFactory.eINSTANCE.createUriItem();
                itemRef.setItemId(item.getId());
                ((UriItem)itemRef).setConnectionUri(item.getConnectionString());
            }
        }
        if (itemRef == null) {
            return;
        }
        ArchiveSeries input = ChartFactory.eINSTANCE.createArchiveSeries();
        input.setLabel(item.toLabel());
        input.setItem((org.eclipse.scada.ui.chart.model.Item)itemRef);
        input.setX(x);
        input.setY(y);
        input.getLineProperties().setColor(Charts.nextFreeColor(chart));
        Charts.addInput(chart, (ItemDataSeries)input);
    }

    public static void addItem(Chart chart, Item item) {
        YAxis y;
        XAxis x = chart.getTimeRulerAxis();
        if (x == null) {
            return;
        }
        try {
            y = (YAxis)chart.getSelectedYAxis().get(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
        IdItem itemRef = null;
        switch (item.getType()) {
            case ID: {
                itemRef = ChartFactory.eINSTANCE.createIdItem();
                itemRef.setConnectionId(item.getId());
                itemRef.setItemId(item.getId());
                break;
            }
            case URI: {
                itemRef = ChartFactory.eINSTANCE.createUriItem();
                ((UriItem)itemRef).setConnectionUri(item.getConnectionString());
                itemRef.setItemId(item.getId());
            }
        }
        if (itemRef == null) {
            return;
        }
        DataItemSeries input = ChartFactory.eINSTANCE.createDataItemSeries();
        input.setLabel(item.toLabel());
        input.setItem((org.eclipse.scada.ui.chart.model.Item)itemRef);
        input.setX(x);
        input.setY(y);
        input.getLineProperties().setColor(Charts.nextFreeColor(chart));
        Charts.addInput(chart, (ItemDataSeries)input);
    }

    private static void addInput(Chart chart, ItemDataSeries input) {
        chart.getInputs().add((Object)input);
    }

    public static void addCompositeQuality(Chart configuration) {
        EList x = configuration.getSelectedXAxis();
        EList y = configuration.getSelectedYAxis();
        if (x.isEmpty()) {
            return;
        }
        if (y.isEmpty()) {
            return;
        }
        CompositeArchiveQualitySeries q = ChartFactory.eINSTANCE.createCompositeArchiveQualitySeries();
        q.setX((XAxis)x.get(0));
        q.setY((YAxis)y.get(0));
        q.setVisible(true);
        q.setThreshold(0.75);
        configuration.getInputs().add((Object)q);
    }
}

