/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.swt.render.AbstractLineRender;
import org.eclipse.scada.ui.chart.viewer.input.AbstractInput;
import org.eclipse.scada.ui.chart.viewer.input.LinePropertiesSupporter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public abstract class LineInput
extends AbstractInput
implements LinePropertiesSupporter {
    private static final RGB DEFAULT_COLOR = new RGB(0, 0, 0);
    private final LocalResourceManager resourceManager;
    private RGB lineColor;
    private final Map<Point, Image> previews = new HashMap<Point, Image>();

    public LineInput(ResourceManager resourceManager) {
        this.resourceManager = new LocalResourceManager(resourceManager);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.resourceManager.dispose();
        this.disposePreviews();
    }

    protected abstract AbstractLineRender getLineRenderer();

    @Override
    public void setVisible(boolean visible) {
        AbstractLineRender renderer = this.getLineRenderer();
        if (renderer != null) {
            renderer.setVisible(visible);
        }
        super.setVisible(visible);
    }

    @Override
    public void setLineColor(RGB rgb) {
        this.lineColor = rgb;
        this.getLineRenderer().setLineColor(rgb);
        this.fireUpdatePreviews();
        this.firePropertyChange("color", null, rgb);
    }

    @Override
    public RGB getLineColor() {
        return this.lineColor;
    }

    public RGB getColor() {
        return this.lineColor;
    }

    @Override
    public void setLineWidth(float width) {
        this.getLineRenderer().setLineWidth(width);
        this.fireUpdatePreviews();
    }

    @Override
    public float getLineWidth() {
        return this.getLineRenderer().getLineWidth();
    }

    @Override
    protected void fireUpdatePreviews() {
        this.disposePreviews();
        super.fireUpdatePreviews();
    }

    private void disposePreviews() {
        for (Image image : this.previews.values()) {
            image.dispose();
        }
        this.previews.clear();
    }

    @Override
    public Image getPreview(int width, int height) {
        Point p = new Point(width, height);
        Image img = this.previews.get(p);
        if (img == null) {
            RGB rgb = this.getLineRenderer().getLineColor();
            if (rgb == null) {
                rgb = DEFAULT_COLOR;
            }
            Color color = (Color)this.resourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)rgb));
            Image newImage = LineInput.makePreview(Display.getDefault(), this.getLineRenderer().getLineAttributes(), color, p);
            this.previews.put(p, newImage);
            return newImage;
        }
        return img;
    }

    public static Image makePreview(Display display, LineAttributes lineAttributes, Color lineColor, Point p) {
        Image img = new Image((Device)display, p.x, p.y);
        GC gc = new GC((Drawable)img);
        try {
            gc.setForeground(img.getDevice().getSystemColor(1));
            gc.setBackground(img.getDevice().getSystemColor(1));
            gc.fillRectangle(0, 0, p.x, p.y);
            gc.setLineAttributes(lineAttributes);
            if (lineColor != null) {
                gc.setForeground(lineColor);
            }
            gc.drawLine(0, p.y / 2, p.x, p.y / 2);
        }
        finally {
            gc.dispose();
        }
        return img;
    }
}

