/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.util;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.ca.client.Connection;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.ca.ui.util.Messages;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class ConfigurationHelper
extends org.eclipse.scada.ca.utils.ConfigurationHelper {
    public static Collection<FactoryInformation> loadData(IProgressMonitor monitor, Connection connection) throws Exception {
        LinkedList<FactoryInformation> result = new LinkedList<FactoryInformation>();
        try {
            if (connection == null) {
                throw new IllegalStateException(Messages.ConfigurationHelper_NoConnection);
            }
            NotifyFuture future = connection.getFactories();
            FactoryInformation[] factories = (FactoryInformation[])future.get();
            monitor.beginTask(Messages.ConfigurationHelper_TaskName, factories.length);
            FactoryInformation[] factoryInformationArray = factories;
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                FactoryInformation factory = factoryInformationArray[n2];
                monitor.subTask(String.format(Messages.ConfigurationHelper_SubTaskNameFormat, factory.getId()));
                result.add((FactoryInformation)connection.getFactoryWithData(factory.getId()).get());
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return null;
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }
}

