/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.user;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.data.SummaryListener;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.ui.draw2d.VisualInterfaceViewer;
import org.eclipse.scada.vi.ui.user.viewer.AbstractViewInstance;
import org.eclipse.scada.vi.ui.user.viewer.ViewInstanceDescriptor;
import org.eclipse.scada.vi.ui.user.viewer.ViewManager;
import org.eclipse.scada.vi.ui.user.viewer.ViewManagerContext;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.services.IEvaluationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualInterfaceViewInstance
extends AbstractViewInstance
implements SummaryListener,
SummaryProvider {
    private static final Logger logger = LoggerFactory.getLogger(VisualInterfaceViewInstance.class);
    private VisualInterfaceViewer viewer;
    private final Composite parent;
    private final Map<String, Object> scriptObjects;
    private SummaryInformation currentSummary;
    private final Set<SummaryListener> summaryListeners = new LinkedHashSet<SummaryListener>();

    public VisualInterfaceViewInstance(ViewManager viewManager, ViewManagerContext viewManagerContext, Composite parent, ViewInstanceDescriptor descriptor, IEvaluationService evaluationService) {
        super(viewManagerContext, descriptor, evaluationService);
        this.parent = parent;
        this.scriptObjects = new HashMap<String, Object>();
        this.scriptObjects.put("viewManager", viewManager);
    }

    @Override
    protected void activateView() {
        if (this.viewer != null) {
            return;
        }
        this.viewer = new VisualInterfaceViewer(this.parent, 0, this.descriptor.getUri(), this.scriptObjects, this.descriptor.getProperties());
        this.viewer.setZooming(this.descriptor.getZooming());
        this.viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.addSummaryListener((SummaryListener)this);
    }

    @Override
    protected void deactivateView() {
        if (this.viewer != null) {
            this.viewer.removeSummaryListener((SummaryListener)this);
            this.viewer.dispose();
            this.viewer = null;
        }
    }

    @Override
    public void setFocus() {
        this.viewer.setFocus();
    }

    @Override
    public Control getControl() {
        return this.viewer;
    }

    public SummaryInformation getSummary() {
        return this.currentSummary;
    }

    public void summaryChanged(SummaryInformation summary) {
        logger.debug("Summary changed: {}", (Object)summary);
        this.currentSummary = summary;
        this.fireSummaryChanged(summary);
    }

    private void fireSummaryChanged(final SummaryInformation summary) {
        for (final SummaryListener listener : this.summaryListeners) {
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.summaryChanged(summary);
                }
            });
        }
    }

    public void addSummaryListener(SummaryListener summaryListener) {
        if (this.summaryListeners.add(summaryListener)) {
            summaryListener.summaryChanged(this.currentSummary);
        }
    }

    public void removeSummaryListener(SummaryListener summaryListener) {
        this.summaryListeners.remove(summaryListener);
    }
}

