/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.dataitem.details.extra.part;

import java.util.HashMap;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.CheckBox;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MidpointLocator;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.dataitem.details.extra.part.AbstractBaseDraw2DDetailsPart;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;

public class RoundDetailsPart
extends AbstractBaseDraw2DDetailsPart {
    private RoundedRectangle sourceRect;
    private Label sourceLabel;
    private RoundedRectangle targetRect;
    private Label targetLabel;
    private Label typeLabel;
    private PolylineConnection roundConnection;
    private CheckBox button;

    @Override
    protected IFigure createMain() {
        Figure rootFigure = new Figure();
        rootFigure.setLayoutManager((LayoutManager)new GridLayout(3, true));
        rootFigure.add((IFigure)this.makeHeader(), (Object)new GridData(1, 2, true, false, 3, 1));
        rootFigure.add(this.createSourceValue(), (Object)new GridData(2, 2, true, true));
        rootFigure.add((IFigure)new Figure());
        rootFigure.add(this.createTargetValue(), (Object)new GridData(2, 2, true, true));
        rootFigure.add((IFigure)new Figure());
        rootFigure.add(this.createCommandPanel(), (Object)new GridData(2, 2, true, true));
        this.createRoundArrow(rootFigure);
        return rootFigure;
    }

    private IFigure createCommandPanel() {
        Figure commandPanel = new Figure();
        commandPanel.setLayoutManager((LayoutManager)new FlowLayout());
        Button noneButton = new Button("NONE");
        commandPanel.add((IFigure)noneButton);
        Button roundButton = new Button("ROUND");
        commandPanel.add((IFigure)roundButton);
        Button ceilButton = new Button("CEIL");
        commandPanel.add((IFigure)ceilButton);
        Button floorButton = new Button("FLOOR");
        commandPanel.add((IFigure)floorButton);
        noneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                RoundDetailsPart.this.setRoundType("NONE");
            }
        });
        roundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                RoundDetailsPart.this.setRoundType("ROUND");
            }
        });
        ceilButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                RoundDetailsPart.this.setRoundType("CEIL");
            }
        });
        floorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                RoundDetailsPart.this.setRoundType("FLOOR");
            }
        });
        return commandPanel;
    }

    private Figure makeHeader() {
        this.button = new CheckBox("Active");
        this.button.getModel().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                RoundDetailsPart.this.setEnabled(RoundDetailsPart.this.button.getModel().isSelected());
            }
        });
        return this.button;
    }

    protected void setEnabled(boolean selected) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(1);
        attributes.put("org.eclipse.scada.da.round.active", Variant.valueOf((boolean)selected));
        this.item.writeAtrtibutes(attributes, null, this.makeDisplayCallback());
    }

    protected void setRoundType(String string) {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("org.eclipse.scada.da.round.type", Variant.valueOf((Object)string));
        this.item.writeAtrtibutes(attributes, null, this.makeDisplayCallback());
    }

    private CallbackHandler makeDisplayCallback() {
        return new DisplayCallbackHandler(this.shell, "Configure Round Operation", "Confirmation required for configuring rounding operation");
    }

    private void createRoundArrow(Figure figure) {
        PolylineConnection c = new PolylineConnection();
        c.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)this.sourceRect));
        c.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)this.targetRect));
        PolygonDecoration dec = new PolygonDecoration();
        dec.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        c.setTargetDecoration((RotatableDecoration)dec);
        MidpointLocator typeLocator = new MidpointLocator((Connection)c, 0);
        typeLocator.setRelativePosition(1);
        this.typeLabel = new Label("");
        c.add((IFigure)this.typeLabel, (Object)typeLocator);
        figure.add((IFigure)c);
        this.roundConnection = c;
    }

    private IFigure createTargetValue() {
        this.targetRect = new RoundedRectangle();
        this.targetRect.setLayoutManager((LayoutManager)new BorderLayout());
        this.targetRect.setBackgroundColor(ColorConstants.lightGray);
        this.targetRect.setForegroundColor(ColorConstants.black);
        this.targetRect.setBorder((Border)new MarginBorder(10));
        this.targetLabel = new Label();
        this.targetRect.add((IFigure)this.targetLabel, (Object)BorderLayout.CENTER);
        return this.targetRect;
    }

    private IFigure createSourceValue() {
        this.sourceRect = new RoundedRectangle();
        this.sourceRect.setLayoutManager((LayoutManager)new BorderLayout());
        this.sourceRect.setBackgroundColor(ColorConstants.lightGray);
        this.sourceRect.setForegroundColor(ColorConstants.black);
        this.sourceRect.setBorder((Border)new MarginBorder(10));
        this.sourceLabel = new Label();
        this.sourceRect.add((IFigure)this.sourceLabel, (Object)BorderLayout.CENTER);
        return this.sourceRect;
    }

    @Override
    protected void update() {
        super.update();
        if (this.value == null) {
            return;
        }
        this.targetLabel.setText(String.format("%s", this.value.getValue()));
        Variant originalValue = (Variant)this.value.getAttributes().get("org.eclipse.scada.da.round.value.original");
        boolean active = this.getBooleanAttribute("org.eclipse.scada.da.round.active");
        Variant type = (Variant)this.value.getAttributes().get("org.eclipse.scada.da.round.type");
        this.button.getModel().setSelected(active);
        if (type != null) {
            this.typeLabel.setText(type.toLabel());
        } else {
            this.typeLabel.setText("");
        }
        if (originalValue == null) {
            this.sourceLabel.setText("");
        } else {
            this.sourceLabel.setText(String.format("%s", originalValue));
        }
        if (active) {
            this.roundConnection.setForegroundColor(ColorConstants.green);
        } else {
            this.roundConnection.setForegroundColor(ColorConstants.darkGray);
        }
        this.typeLabel.setForegroundColor(ColorConstants.black);
    }

    @Override
    protected boolean isAvailable() {
        return this.hasAttribute("org.eclipse.scada.da.round.active");
    }
}

