/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.chart.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.ui.chart.model.Chart;
import org.eclipse.scada.ui.chart.model.ChartFactory;
import org.eclipse.scada.ui.chart.model.XAxis;
import org.eclipse.scada.ui.chart.model.YAxis;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.ExtensionSpaceProvider;
import org.eclipse.scada.ui.chart.viewer.NullExtensionSpace;
import org.eclipse.scada.vi.ui.chart.draw2d.Draw2DGraphics;
import org.eclipse.scada.vi.ui.chart.draw2d.FigureRenderer;
import org.eclipse.swt.widgets.Display;

public class ChartFigure
extends Figure {
    private FigureRenderer renderer;
    private ChartViewer viewer;
    private Chart configuration;
    private boolean realize;
    private final ResourceManager parentResourceManager;
    private LocalResourceManager resourceManager;
    private final Display display;

    public ChartFigure(Display display, ResourceManager parentResourceManager) {
        this.display = display;
        this.parentResourceManager = parentResourceManager;
    }

    public void setConfiguration(Chart configuration) {
        this.doDisposeRenderer();
        this.configuration = configuration;
        this.checkCreate();
    }

    public void addNotify() {
        super.addNotify();
        this.createRenderer();
    }

    public void removeNotify() {
        this.disposeRenderer();
        super.removeNotify();
    }

    private static Chart makeDefaultConfiguration() {
        Chart configuration = ChartFactory.eINSTANCE.createChart();
        YAxis y = ChartFactory.eINSTANCE.createYAxis();
        y.setLabel("Values");
        configuration.getLeft().add((Object)y);
        XAxis x = ChartFactory.eINSTANCE.createXAxis();
        x.setLabel("Time");
        x.setFormat("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS.%1$tL");
        x.setMinimum(System.currentTimeMillis());
        x.setMaximum(System.currentTimeMillis() + 900000L);
        configuration.getBottom().add((Object)x);
        configuration.getSelectedXAxis().add((Object)x);
        configuration.getSelectedYAxis().add((Object)y);
        return configuration;
    }

    protected void disposeRenderer() {
        this.realize = false;
        this.doDisposeRenderer();
    }

    private void doDisposeRenderer() {
        if (this.viewer != null) {
            this.viewer.dispose();
            this.viewer = null;
        }
        if (this.renderer != null) {
            this.renderer.dispose();
            this.renderer = null;
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    protected void createRenderer() {
        this.disposeRenderer();
        this.realize = true;
        this.checkCreate();
    }

    private void doCreateRenderer() {
        this.resourceManager = new LocalResourceManager(this.parentResourceManager);
        this.renderer = new FigureRenderer(this, (ResourceManager)this.resourceManager);
        this.viewer = new ChartViewer(this.display, (ChartRenderer)this.renderer, this.configuration != null ? this.configuration : ChartFigure.makeDefaultConfiguration(), (ExtensionSpaceProvider)new NullExtensionSpace(), null);
    }

    private void checkCreate() {
        if (this.configuration != null && this.realize) {
            this.doCreateRenderer();
        }
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        if (this.renderer != null) {
            this.renderer.handleResize();
        }
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.renderer != null) {
            Draw2DGraphics g = new Draw2DGraphics(graphics, this.resourceManager.getDevice());
            try {
                this.renderer.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }
}

