/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.client.signalgenerator.page;

import org.eclipse.scada.da.ui.client.signalgenerator.SimulationTarget;
import org.eclipse.scada.da.ui.client.signalgenerator.page.BooleanGenerator;
import org.eclipse.scada.da.ui.client.signalgenerator.page.GeneratorPage;
import org.eclipse.scada.da.ui.client.signalgenerator.page.Messages;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class BooleanGeneratorPage
implements GeneratorPage {
    private Spinner startDelaySpinner;
    private Spinner endDelaySpinner;
    private Composite parent;
    private BooleanGenerator generator;
    private SimulationTarget target;

    @Override
    public void createPage(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout(512));
        this.createTimedGroup(parent);
        this.update();
    }

    private void createTimedGroup(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        new Label(parent, 0).setText(Messages.getString("BooleanGeneratorPage.timedGroup.beforeDelay"));
        new Label(parent, 0).setText(Messages.getString("BooleanGeneratorPage.timedGroup.0to1"));
        new Label(parent, 0).setText(Messages.getString("BooleanGeneratorPage.timedGroup.afterDelay"));
        new Label(parent, 0).setText(Messages.getString("BooleanGeneratorPage.timedGroup.1to0"));
        this.startDelaySpinner = new Spinner(parent, 2048);
        this.startDelaySpinner.setValues(1000, 0, Integer.MAX_VALUE, 0, 100, 1000);
        new Label(parent, 0).setText(Messages.getString("BooleanGeneratorPage.timedGroup.transition"));
        this.endDelaySpinner = new Spinner(parent, 2048);
        this.endDelaySpinner.setValues(1000, 0, Integer.MAX_VALUE, 0, 100, 1000);
    }

    @Override
    public void start() {
        int startDelay = this.startDelaySpinner.getSelection();
        int endDelay = this.endDelaySpinner.getSelection();
        this.generator = new BooleanGenerator(this.parent.getDisplay(), this.target);
        this.generator.setStartDelay(startDelay);
        this.generator.setEndDelay(endDelay);
        this.generator.start();
    }

    @Override
    public void stop() {
        this.dispose();
    }

    @Override
    public void dispose() {
        if (this.generator != null) {
            this.generator.dispose();
            this.generator = null;
        }
    }

    @Override
    public void setTarget(SimulationTarget target) {
        this.target = target;
        this.update();
    }

    private void update() {
        this.startDelaySpinner.setEnabled(this.generator == null);
        this.endDelaySpinner.setEnabled(this.generator == null);
    }
}

