/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.views;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.ui.testing.views.AbstractEventQueryViewPart;
import org.eclipse.scada.ae.ui.testing.views.EventViewHelper;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventQueryView
extends AbstractEventQueryViewPart {
    private static final Logger logger = LoggerFactory.getLogger(EventQueryView.class);
    public static final String VIEW_ID = "org.eclipse.scada.ae.ui.testing.views.EventQueryView";
    private Label stateLabel;
    private final Set<Event> eventSet = new HashSet<Event>();
    final WritableSet events = new WritableSet(SWTObservables.getRealm((Display)Display.getDefault()));
    private TableViewer viewer;

    @Override
    protected Realm getRealm() {
        return this.events.getRealm();
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.stateLabel = new Label(parent, 0);
        this.stateLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = EventViewHelper.createTableViewer(wrapper, this.getViewSite(), (IObservableSet)this.events);
        this.hookContextMenu();
        this.addSelectionListener();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu", VIEW_ID);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EventQueryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    protected void clear() {
        super.clear();
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                EventQueryView.this.eventSet.clear();
                EventQueryView.this.events.clear();
                EventQueryView.this.stateLabel.setText("<no query selected>");
            }
        });
    }

    @Override
    protected void handleDataChanged(final List<Event> addedEvents) {
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                EventQueryView.this.performDataChanged(addedEvents);
            }
        });
    }

    protected void performDataChanged(List<Event> addedEvents) {
        try {
            this.events.setStale(true);
            for (Event event : addedEvents) {
                this.events.add((Object)event);
            }
        }
        finally {
            this.events.setStale(false);
        }
        try {
            this.viewer.getTable().setTopIndex(0);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Failed to scroll up", (Throwable)e);
        }
    }

    @Override
    public void handleStatusChanged(SubscriptionState status) {
        this.triggerStateUpdate(status);
    }

    private void triggerStateUpdate(final SubscriptionState status) {
        if (this.stateLabel.isDisposed()) {
            return;
        }
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                EventQueryView.this.performEventStatusUpdate(status);
            }
        });
    }

    protected void performEventStatusUpdate(SubscriptionState status) {
        if (this.stateLabel.isDisposed()) {
            return;
        }
        this.stateLabel.setText(status.toString());
        switch (status) {
            case DISCONNECTED: 
            case GRANTED: {
                this.events.clear();
                this.eventSet.clear();
                break;
            }
        }
    }
}

