/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.data;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.core.ui.styles.StateInformation;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryStateInformation;

public class SummaryInformation {
    private final Map<String, DataValue> data;
    private final Collection<SummaryInformation> childData;
    private final List<String> nameHierarchy;
    private static String PAD = "   ";

    public SummaryInformation(List<String> nameHierarchy, Map<String, DataValue> data, Collection<SummaryInformation> childData) {
        this.nameHierarchy = nameHierarchy;
        this.data = data;
        this.childData = childData == null ? Collections.emptyList() : childData;
    }

    public SummaryInformation(Map<String, DataValue> data) {
        this(Collections.emptyList(), data, Collections.emptyList());
    }

    public boolean isValid() {
        for (Map.Entry<String, DataValue> entry : this.data.entrySet()) {
            DataItemValue value;
            if (entry.getValue() == null || entry.getValue().isIgnoreSummary() || (value = entry.getValue().getValue()) != null && value.isConnected() && !value.isError() && value.getValue() != null && (!value.getValue().isNull() || !entry.getValue().isNullInvalid())) continue;
            return false;
        }
        for (SummaryInformation child : this.childData) {
            if (child.isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean isConnected() {
        for (Map.Entry<String, DataValue> entry : this.data.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isIgnoreSummary() || entry.getValue().getValue().isConnected()) continue;
            return false;
        }
        for (SummaryInformation child : this.childData) {
            if (child.isConnected()) continue;
            return false;
        }
        return true;
    }

    public boolean isError() {
        return this.isAttribute("error", false);
    }

    public boolean isAlarm() {
        return this.isAttribute("alarm", false);
    }

    public boolean isWarning() {
        return this.isAttribute("warning", false);
    }

    public boolean isManual() {
        return this.isAttribute("manual", false);
    }

    public boolean isBlocked() {
        return this.isAttribute("blocked", false);
    }

    public boolean isAckRequired(String severity) {
        return this.isAttribute(String.valueOf(severity) + ".ackRequired", false);
    }

    public boolean isAttribute(String attributeName, boolean defaultValue) {
        for (DataValue value : this.data.values()) {
            if (value == null || value.getValue() == null || value.isIgnoreSummary() || !value.getValue().isAttribute(attributeName, defaultValue)) continue;
            return true;
        }
        for (SummaryInformation child : this.childData) {
            if (!child.isAttribute(attributeName, defaultValue)) continue;
            return true;
        }
        return false;
    }

    public StateInformation getStateInformation() {
        return new SummaryStateInformation(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[attrs: " + this.data.size());
        sb.append(", childs: " + this.childData.size());
        sb.append(", valid: " + this.isValid());
        sb.append(", error: " + this.isError());
        sb.append(", alarm: " + this.isAlarm());
        sb.append(", manual: " + this.isManual());
        sb.append(", blocked: " + this.isBlocked());
        sb.append("]");
        return sb.toString();
    }

    public void dump(PrintStream out) {
        this.dump("", out);
    }

    protected void dump(String in, PrintStream out) {
        out.println(String.valueOf(in) + PAD + "name: " + this.nameHierarchy);
        out.print(String.valueOf(in) + PAD + "valid: " + this.isValid());
        out.print(", connected: " + this.isConnected());
        out.print(", error: " + this.isError());
        out.print(", alarm: " + this.isAlarm());
        out.print(", warning: " + this.isWarning());
        out.print(", manual: " + this.isManual());
        out.print(", blocked: " + this.isBlocked());
        out.println();
        if (!this.data.isEmpty()) {
            out.println(String.valueOf(in) + PAD + "data:");
            for (Map.Entry entry : this.data.entrySet()) {
                out.print(String.valueOf(in) + PAD + PAD + (String)entry.getKey() + "=>");
                ((DataValue)entry.getValue()).dump(out);
                out.println();
            }
        }
        if (!this.childData.isEmpty()) {
            out.println(String.valueOf(in) + PAD + "children:");
            for (SummaryInformation summaryInformation : this.childData) {
                summaryInformation.dump(String.valueOf(in) + PAD + PAD, out);
            }
        }
    }
}

