/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.loader;

import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.scada.vi.model.Symbol;
import org.eclipse.scada.vi.ui.draw2d.loader.SymbolLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticSymbolLoader
implements SymbolLoader {
    private static final Logger logger = LoggerFactory.getLogger(StaticSymbolLoader.class);
    private final Symbol symbol;
    private final ClassLoader classLoader;

    public StaticSymbolLoader(Symbol symbol, ClassLoader classLoader) {
        this.symbol = symbol;
        this.classLoader = classLoader;
    }

    @Override
    public String getSourceName() {
        Resource r = this.symbol.eResource();
        if (r != null && r.getURI() == null) {
            return r.getURI().toString();
        }
        return "<unknown>";
    }

    @Override
    public Symbol loadSymbol() {
        return this.symbol;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String resolveUri(String uri) {
        Resource r = this.symbol.eResource();
        if (r == null) {
            return uri;
        }
        URI u = r.getURI();
        if (u == null) {
            return uri;
        }
        logger.debug("Resolve - base: {}, uri: {}", (Object)u, (Object)uri);
        return URI.createURI((String)uri).resolve(u).toString();
    }

    @Override
    public String loadStringResource(String url) throws Exception {
        String target = this.resolveUri(url);
        logger.debug("Loading resource from: {}", (Object)target);
        return Resources.toString((URL)new URL(target), (Charset)Charset.forName("UTF-8"));
    }
}

