/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.ui.draw2d.loader;

import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.scada.vi.model.Symbol;
import org.eclipse.scada.vi.model.VisualInterfacePackage;
import org.eclipse.scada.vi.ui.draw2d.Activator;
import org.eclipse.scada.vi.ui.draw2d.loader.SymbolLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMISymbolLoader
implements SymbolLoader {
    private static final Logger logger = LoggerFactory.getLogger(XMISymbolLoader.class);
    private final URI uri;
    private Symbol symbol;
    private final ClassLoader classLoader;

    public XMISymbolLoader(String uri) {
        this(URI.createURI((String)uri));
    }

    public XMISymbolLoader(URI uri) {
        this.uri = uri;
        this.classLoader = this.findClassLoader();
    }

    @Override
    public String getSourceName() {
        return this.uri.toString();
    }

    private ClassLoader findClassLoader() {
        return Activator.class.getClassLoader();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Symbol loadSymbol() throws Exception {
        if (this.symbol == null) {
            this.load();
            if (this.symbol == null) {
                throw new IllegalStateException(String.format("Resource '%s' did not contain a symbol", this.uri));
            }
        }
        return this.symbol;
    }

    @Override
    public String resolveUri(String uri) {
        String result = URI.createURI((String)uri).resolve(this.uri).toString();
        logger.debug("Resolved URI: {} -> {}", (Object)uri, (Object)result);
        return result;
    }

    @Override
    public String loadStringResource(String url) throws Exception {
        String target = this.resolveUri(url);
        logger.debug("Loading resource from: {}", (Object)target);
        return Resources.toString((URL)new URL(target), (Charset)Charset.forName("UTF-8"));
    }

    protected void load() throws Exception {
        VisualInterfacePackage.eINSTANCE.eClass();
        this.symbol = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("vi", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.getResource(this.uri, true);
        this.symbol = (Symbol)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)VisualInterfacePackage.Literals.SYMBOL);
    }
}

