/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.importer.wizard;

import java.util.List;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.data.Operation;
import org.eclipse.scada.ca.ui.importer.wizard.DiffEntryHelper;
import org.eclipse.scada.ca.ui.importer.wizard.DiffSubEntry;

public class LazyDiffEntryTreeProvider
implements ILazyTreeContentProvider {
    private TreeViewer viewer;
    private Object input;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
        this.viewer = viewer instanceof TreeViewer ? (TreeViewer)viewer : null;
    }

    public void updateElement(Object parent, int index) {
        if (this.viewer == null) {
            return;
        }
        if (parent instanceof List) {
            Object element = ((List)parent).get(index);
            this.viewer.replace(parent, index, element);
            this.updateChildCount(element, -1);
        } else if (parent instanceof DiffEntry) {
            this.viewer.replace(parent, index, DiffEntryHelper.diffChildsByIndex((DiffEntry)parent, index));
        }
    }

    public void updateChildCount(Object element, int currentChildCount) {
        if (this.viewer == null) {
            return;
        }
        int count = 0;
        if (element instanceof DiffEntry) {
            Operation op = ((DiffEntry)element).getOperation();
            if (op == Operation.UPDATE_DIFF || op == Operation.UPDATE_SET || op == Operation.ADD) {
                Object[] childs = DiffEntryHelper.diffChilds((DiffEntry)element);
                count = childs.length;
            }
        } else if (element instanceof List) {
            count = ((List)element).size();
        }
        if (count != currentChildCount) {
            this.viewer.setChildCount(element, count);
        }
    }

    public Object getParent(Object element) {
        if (element instanceof DiffSubEntry) {
            return ((DiffSubEntry)element).getParentEntry();
        }
        if (element instanceof DiffEntry) {
            return this.input;
        }
        return null;
    }
}

