/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.importer.wizard;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.ui.importer.wizard.DiffEntryComparator;
import org.eclipse.scada.ca.ui.importer.wizard.DiffEntryLabelProvider;
import org.eclipse.scada.ca.ui.importer.wizard.LazyDiffEntryTreeProvider;
import org.eclipse.scada.ca.ui.importer.wizard.Messages;
import org.eclipse.scada.ca.ui.util.DiffController;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class PreviewPage
extends WizardPage {
    private final DiffController mergeController;
    private TreeViewer viewer;
    private Label statsLabel;
    private LocalResourceManager resourceManager;

    public PreviewPage(DiffController mergeController) {
        super("previewPage");
        this.setTitle(Messages.PreviewPage_PageTitle);
        this.mergeController = mergeController;
    }

    public void createControl(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(1, false));
        this.viewer = new TreeViewer(wrapper, 268438274);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        TableLayout layout = new TableLayout();
        this.viewer.getTree().setLayout((Layout)layout);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()), this.viewer.getControl());
        TreeViewerColumn col = new TreeViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.PreviewPage_ColFactoryText);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        col.setLabelProvider((CellLabelProvider)new DiffEntryLabelProvider((ResourceManager)this.resourceManager));
        col = new TreeViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.PreviewPage_ColConfigurationText);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        col.setLabelProvider((CellLabelProvider)new DiffEntryLabelProvider((ResourceManager)this.resourceManager));
        col = new TreeViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.PreviewPage_ColOperationText);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        col.setLabelProvider((CellLabelProvider)new DiffEntryLabelProvider((ResourceManager)this.resourceManager));
        col = new TreeViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.PreviewPage_ColDataText);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        col.setLabelProvider((CellLabelProvider)new DiffEntryLabelProvider((ResourceManager)this.resourceManager));
        col = new TreeViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.PreviewPage_ColCurrentDataText);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        col.setLabelProvider((CellLabelProvider)new DiffEntryLabelProvider((ResourceManager)this.resourceManager));
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new LazyDiffEntryTreeProvider());
        this.viewer.setUseHashlookup(true);
        this.statsLabel = new Label(wrapper, 0);
        this.statsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setControl((Control)wrapper);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        PreviewPage.this.setMergeResult(PreviewPage.this.mergeController.merge(monitor));
                    }
                });
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.scada.ca.ui.importer", Messages.PreviewPage_StatusErrorFailedToMerge, (Throwable)e);
                StatusManager.getManager().handle((IStatus)status);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.PreviewPage_TitleErrorFailedToMerge, (String)Messages.PreviewPage_MessageErrorFailedToMerge, (IStatus)status);
            }
        }
    }

    private void setMergeResult(List<DiffEntry> merge) {
        Collections.sort(merge, new DiffEntryComparator());
        this.viewer.setInput(merge);
        this.statsLabel.setText(MessageFormat.format(Messages.PreviewPage_StatusLabel, merge.size()));
    }
}

