/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.source.ValueSourceController;

public abstract class CompositeTransformerController
implements ValueSourceController {
    private static final String[] SEVERITIES = new String[]{"error", "alarm", "warning"};
    protected final List<ValueSourceController> values;
    protected SummaryInformation state;

    public CompositeTransformerController(List<ValueSourceController> values) {
        this.values = values;
    }

    @Override
    public abstract DataItemValue value();

    @Override
    public void updateData(Map<String, DataValue> values, SummaryInformation state) {
        for (ValueSourceController controller : this.values) {
            controller.updateData(values, state);
        }
        this.state = state;
    }

    protected SubscriptionState createState() {
        SubscriptionState state = !this.state.isConnected() ? SubscriptionState.DISCONNECTED : SubscriptionState.CONNECTED;
        return state;
    }

    protected Map<String, Variant> createAttributes() {
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("error", Variant.valueOf((boolean)this.state.isError()));
        attributes.put("manual", Variant.valueOf((boolean)this.state.isManual()));
        attributes.put("alarm", Variant.valueOf((boolean)this.state.isAlarm()));
        String[] stringArray = SEVERITIES;
        int n = SEVERITIES.length;
        int n2 = 0;
        while (n2 < n) {
            String severity = stringArray[n2];
            attributes.put(String.valueOf(severity) + ".ackRequired", Variant.valueOf((boolean)this.state.isAckRequired(severity)));
            ++n2;
        }
        return attributes;
    }
}

