/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scada.da.client.dataitem.details.dialog.DataItemDetailsDialog;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.da.ui.widgets.realtime.ListEntry;
import org.eclipse.scada.da.ui.widgets.realtime.RealTimeListViewer;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.data.SummaryListener;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.details.model.Visibility;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.impl.GroupTab;
import org.eclipse.scada.vi.details.swt.impl.Messages;
import org.eclipse.scada.vi.details.swt.impl.visibility.VisibilityProviderFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

class RealTimeGroupTab
implements GroupTab {
    private RealTimeListViewer viewer;
    private Shell shell;
    private IObservableSet input;
    private final Map<Item, ListEntry> entryMap = new HashMap<Item, ListEntry>();
    private final ISetChangeListener setListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            DataItemDescriptor item;
            for (Object object : event.diff.getAdditions()) {
                item = (DataItemDescriptor)object;
                RealTimeGroupTab.this.addItem(item);
            }
            for (Object object : event.diff.getRemovals()) {
                item = (DataItemDescriptor)object;
                RealTimeGroupTab.this.removeItem(item);
            }
        }
    };

    @Override
    public void dispose() {
        if (this.viewer != null) {
            this.viewer.dispose();
        }
        if (this.input != null) {
            this.input.dispose();
            this.input = null;
        }
    }

    @Override
    public String getLabel() {
        return Messages.RealTimeGroupTab_TabLabel;
    }

    @Override
    public void init(VisibilityProviderFactory factory, Composite parent, Map<String, String> properties) {
        this.shell = parent.getShell();
        this.viewer = new RealTimeListViewer();
        this.viewer.createControl(parent);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RealTimeGroupTab.this.handleDoubleClick(event);
            }
        });
        if (this.input != null) {
            this.attachInput();
        }
    }

    private void attachInput() {
        this.input.addSetChangeListener(this.setListener);
        for (Object object : this.input) {
            DataItemDescriptor item = (DataItemDescriptor)object;
            this.addItem(item);
        }
    }

    protected void addItem(DataItemDescriptor descriptor) {
        if (this.viewer == null) {
            return;
        }
        Item item = RealTimeGroupTab.convertItem(descriptor);
        if (this.entryMap.containsKey(item)) {
            return;
        }
        ListEntry entry = new ListEntry();
        entry.setDataItem(item);
        this.viewer.add(entry);
        this.entryMap.put(item, entry);
    }

    protected void removeItem(DataItemDescriptor descriptor) {
        if (this.viewer == null) {
            return;
        }
        Item item = RealTimeGroupTab.convertItem(descriptor);
        ListEntry entry = this.entryMap.remove(item);
        if (entry == null) {
            return;
        }
        this.viewer.remove(entry);
    }

    private void detachInput() {
        if (this.input != null) {
            this.input.removeSetChangeListener(this.setListener);
        }
        this.viewer.clear();
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        Object o;
        if (event.getSelection() instanceof IStructuredSelection && (o = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof ListEntry) {
            DataItemDetailsDialog dlg = new DataItemDetailsDialog(this.shell, ((ListEntry)o).getItem());
            dlg.open();
        }
    }

    public IObservableSet setInput(IObservableSet input) {
        IObservableSet oldInput = this.input;
        if (this.input != null) {
            this.detachInput();
        }
        if (this.viewer != null && input != null) {
            this.input = input;
            this.attachInput();
        }
        return oldInput;
    }

    private static Item convertItem(DataItemDescriptor item) {
        return new Item(item.getConnectionInformation().toString(), item.getItemId(), Item.Type.ID);
    }

    @Override
    public IObservableSet getDescriptors() {
        return Observables.emptyObservableSet();
    }

    @Override
    public Visibility getVisibility() {
        return null;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public SummaryProvider getSummaryProvider() {
        return new SummaryProvider(){

            public SummaryInformation getSummary() {
                return new SummaryInformation(Collections.emptyMap());
            }

            public void addSummaryListener(SummaryListener summaryListener) {
            }

            public void removeSummaryListener(SummaryListener summaryListener) {
            }
        };
    }
}

