/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.config;

import com.google.common.base.Enums;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.ui.views.config.AlarmNotifierConfiguration;
import org.eclipse.scada.ae.ui.views.config.ColumnLabelProviderInformation;
import org.eclipse.scada.ae.ui.views.config.ConnectionType;
import org.eclipse.scada.ae.ui.views.config.EventHistoryViewConfiguration;
import org.eclipse.scada.ae.ui.views.config.EventPoolViewConfiguration;
import org.eclipse.scada.ae.ui.views.config.MonitorViewConfiguration;
import org.eclipse.scada.ae.ui.views.views.ColumnProperties;
import org.eclipse.scada.ae.ui.views.views.table.VariantLabelProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationHelper {
    private static final int DEFAULT_INITIAL_SIZE = 120;
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationHelper.class);
    private static final String EXTP_CFG_ID = "org.eclipse.scada.ae.ui.views.configuration";

    public static MonitorViewConfiguration findMonitorViewConfiguration(String configurationId) {
        if (configurationId == null) {
            return null;
        }
        for (MonitorViewConfiguration cfg : ConfigurationHelper.loadAllMonitorConfigurations()) {
            if (!configurationId.equals(cfg.getId())) continue;
            return cfg;
        }
        return null;
    }

    public static List<MonitorViewConfiguration> loadAllMonitorConfigurations() {
        ArrayList<MonitorViewConfiguration> result = new ArrayList<MonitorViewConfiguration>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_CFG_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorViewConfiguration cfg;
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if ("monitorView".equals(ele.getName()) && (cfg = ConfigurationHelper.convertMonitor(ele)) != null) {
                result.add(cfg);
            }
            ++n2;
        }
        return result;
    }

    private static MonitorViewConfiguration convertMonitor(IConfigurationElement ele) {
        try {
            String id = ele.getAttribute("id");
            String monitorQueryId = ele.getAttribute("monitorQueryId");
            String connectionString = ele.getAttribute("connectionString");
            ConnectionType connectionType = ConnectionType.valueOf(ele.getAttribute("connectionType"));
            String label = ele.getAttribute("label");
            List<ColumnProperties> columns = ConfigurationHelper.parseColumnSettings(ele.getAttribute("columns"));
            return new MonitorViewConfiguration(id, monitorQueryId, connectionString, connectionType, label, columns);
        }
        catch (Exception exception) {
            logger.warn("Failed to convert monitor configuration: {}", (Object)ele);
            return null;
        }
    }

    public static EventPoolViewConfiguration findEventPoolViewConfiguration(String configurationId) {
        if (configurationId == null) {
            return null;
        }
        for (EventPoolViewConfiguration cfg : ConfigurationHelper.loadAllEventPoolConfigurations()) {
            if (!configurationId.equals(cfg.getId())) continue;
            return cfg;
        }
        return null;
    }

    public static List<EventPoolViewConfiguration> loadAllEventPoolConfigurations() {
        ArrayList<EventPoolViewConfiguration> result = new ArrayList<EventPoolViewConfiguration>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_CFG_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventPoolViewConfiguration cfg;
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if ("eventPoolView".equals(ele.getName()) && (cfg = ConfigurationHelper.convertEventPool(ele)) != null) {
                result.add(cfg);
            }
            ++n2;
        }
        return result;
    }

    private static EventPoolViewConfiguration convertEventPool(IConfigurationElement ele) {
        try {
            String id = ele.getAttribute("id");
            String monitorQueryId = ele.getAttribute("monitorQueryId");
            String connectionString = ele.getAttribute("connectionString");
            String eventPoolQueryId = ele.getAttribute("eventPoolQueryId");
            ConnectionType connectionType = ConnectionType.valueOf(ele.getAttribute("connectionType"));
            String label = ele.getAttribute("label");
            int maxNumberOfEvents = 0;
            int forceEventLimit = Integer.getInteger("org.eclipse.scada.ae.ui.views.config.defaultForceLimit", 200000);
            try {
                forceEventLimit = Integer.parseInt(ele.getAttribute("forceEventLimit"));
            }
            catch (Exception exception) {}
            if (Arrays.asList(ele.getAttributeNames()).contains("maxNumberOfEvents")) {
                String s = ele.getAttribute("maxNumberOfEvents");
                try {
                    maxNumberOfEvents = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            LinkedList<ColumnLabelProviderInformation> columnInformation = new LinkedList<ColumnLabelProviderInformation>();
            ConfigurationHelper.fillColumnInformation(columnInformation, ele);
            return new EventPoolViewConfiguration(id, monitorQueryId, eventPoolQueryId, connectionString, connectionType, label, maxNumberOfEvents, forceEventLimit, columnInformation);
        }
        catch (Exception exception) {
            logger.warn("Failed to convert event pool configuration: {}", (Object)ele);
            return null;
        }
    }

    private static void fillColumnInformation(List<ColumnLabelProviderInformation> columnInformation, IConfigurationElement ele) {
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        String definitionId = ele.getAttribute("columnInformationDefinition");
        if (definitionId != null && !definitionId.isEmpty()) {
            iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_CFG_ID);
            n2 = iConfigurationElementArray.length;
            n = 0;
            while (n < n2) {
                IConfigurationElement defEle = iConfigurationElementArray[n];
                if ("columnInformationDefinition".equals(defEle.getName())) {
                    ConfigurationHelper.fillColumnInformation(columnInformation, defEle);
                }
                ++n;
            }
        }
        iConfigurationElementArray = ele.getChildren("columnInformation");
        n2 = iConfigurationElementArray.length;
        n = 0;
        while (n < n2) {
            IConfigurationElement child = iConfigurationElementArray[n];
            String type = child.getAttribute("type");
            String label = child.getAttribute("label");
            int initialSize = 120;
            try {
                initialSize = Integer.parseInt(child.getAttribute("initialSize"));
            }
            catch (Exception exception) {}
            boolean sortable = Boolean.parseBoolean(child.getAttribute("sortable"));
            HashMap<String, String> parameters = new HashMap<String, String>();
            IConfigurationElement[] iConfigurationElementArray2 = child.getChildren("columnParameter");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement param = iConfigurationElementArray2[n4];
                String key = param.getAttribute("key");
                String value = param.getAttribute("value");
                if (key != null) {
                    parameters.put(key, value);
                }
                ++n4;
            }
            if (type != null) {
                columnInformation.add(new ColumnLabelProviderInformation(label, type, sortable, initialSize, parameters));
            }
            ++n;
        }
        if (columnInformation.isEmpty()) {
            ConfigurationHelper.fillWithDefault(columnInformation);
        }
    }

    private static void fillWithDefault(List<ColumnLabelProviderInformation> columnInformation) {
        columnInformation.add(new ColumnLabelProviderInformation("sourceTimestamp", "sourceTimestamp", true, 120, Collections.emptyMap()));
        Event.Fields[] fieldsArray = Event.Fields.values();
        int n = fieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Event.Fields field = fieldsArray[n2];
            if (Enums.getField((Enum)field).getAnnotation(Deprecated.class) == null) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("key", field.getName());
                switch (field) {
                    case ACTOR_NAME: {
                        properties.put("decoration", VariantLabelProvider.Decoration.ACTOR.toString());
                        break;
                    }
                    case EVENT_TYPE: {
                        properties.put("decoration", VariantLabelProvider.Decoration.MONITOR.toString());
                        break;
                    }
                }
                columnInformation.add(new ColumnLabelProviderInformation(field.getName(), "variant", false, 120, properties));
            }
            ++n2;
        }
        columnInformation.add(new ColumnLabelProviderInformation("entryTimestamp", "entryTimestamp", true, 120, Collections.emptyMap()));
    }

    private static List<ColumnProperties> parseColumnSettings(String columns) {
        ArrayList<ColumnProperties> result = new ArrayList<ColumnProperties>();
        if (columns == null || "".equals(columns.trim())) {
            return result;
        }
        String[] stringArray = columns.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            String[] settings = col.split(":");
            if (settings.length != 0) {
                ColumnProperties cp = new ColumnProperties();
                if (settings.length > 0) {
                    cp.setNo(Integer.parseInt(settings[0]));
                }
                if (settings.length > 1) {
                    cp.setWidth(Integer.parseInt(settings[1]));
                }
                result.add(cp);
            }
            ++n2;
        }
        return result;
    }

    public static EventHistoryViewConfiguration findEventHistoryViewConfiguration(String configurationId) {
        if (configurationId == null) {
            return null;
        }
        for (EventHistoryViewConfiguration cfg : ConfigurationHelper.loadAllEventHistoryConfigurations()) {
            if (!configurationId.equals(cfg.getId())) continue;
            return cfg;
        }
        return null;
    }

    public static List<EventHistoryViewConfiguration> loadAllEventHistoryConfigurations() {
        ArrayList<EventHistoryViewConfiguration> result = new ArrayList<EventHistoryViewConfiguration>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_CFG_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventHistoryViewConfiguration cfg;
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if ("eventHistoryView".equals(ele.getName()) && (cfg = ConfigurationHelper.convertEventHistory(ele)) != null) {
                result.add(cfg);
            }
            ++n2;
        }
        return result;
    }

    private static EventHistoryViewConfiguration convertEventHistory(IConfigurationElement ele) {
        try {
            String id = ele.getAttribute("id");
            String connectionString = ele.getAttribute("connectionString");
            ConnectionType connectionType = ConnectionType.valueOf(ele.getAttribute("connectionType"));
            String label = ele.getAttribute("label");
            LinkedList<ColumnLabelProviderInformation> columnInformation = new LinkedList<ColumnLabelProviderInformation>();
            ConfigurationHelper.fillColumnInformation(columnInformation, ele);
            return new EventHistoryViewConfiguration(id, connectionString, connectionType, label, columnInformation);
        }
        catch (Exception exception) {
            logger.warn("Failed to convert event history configuration: {}", (Object)ele);
            return null;
        }
    }

    public static AlarmNotifierConfiguration findAlarmNotifierConfiguration() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_CFG_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlarmNotifierConfiguration cfg;
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if ("alarmNotifier".equals(ele.getName()) && (cfg = ConfigurationHelper.convertAlarmNotifier(ele)) != null) {
                return cfg;
            }
            ++n2;
        }
        return null;
    }

    private static AlarmNotifierConfiguration convertAlarmNotifier(IConfigurationElement ele) {
        try {
            String connectionId = ele.getAttribute("connectionId");
            String prefix = ele.getAttribute("prefix") == null ? "ae.server.info" : ele.getAttribute("prefix");
            URL soundFile = Platform.getBundle((String)ele.getContributor().getName()).getEntry(ele.getAttribute("soundFile"));
            ParameterizedCommand ackAlarmsAvailableCommand = ConfigurationHelper.convertCommand(ele.getChildren("ackAlarmsAvailableCommand")[0]);
            ParameterizedCommand alarmsAvailableCommand = ConfigurationHelper.convertCommand(ele.getChildren("alarmsAvailableCommand")[0]);
            return new AlarmNotifierConfiguration(connectionId, prefix, soundFile, ackAlarmsAvailableCommand, alarmsAvailableCommand);
        }
        catch (Exception exception) {
            logger.warn("Failed to convert alarm notifier configuration: {}", (Object)ele);
            return null;
        }
    }

    private static ParameterizedCommand convertCommand(IConfigurationElement commandElement) throws NotDefinedException, InvalidRegistryObjectException {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(commandElement.getAttribute("id"));
        ArrayList<Parameterization> parameters = new ArrayList<Parameterization>();
        IConfigurationElement[] iConfigurationElementArray = commandElement.getChildren("parameter");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement parameter = iConfigurationElementArray[n2];
            IParameter name = command.getParameter(parameter.getAttribute("name"));
            String value = parameter.getAttribute("value");
            parameters.add(new Parameterization(name, value));
            ++n2;
        }
        return new ParameterizedCommand(command, parameters.toArray(new Parameterization[0]));
    }
}

