/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.ui.views.Messages;
import org.eclipse.scada.ae.ui.views.dialog.FilterChangedListener;
import org.eclipse.scada.utils.filter.Assertion;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterAssertion;
import org.eclipse.scada.utils.filter.FilterExpression;
import org.eclipse.scada.utils.filter.Operator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FilterAdvancedComposite
extends Composite {
    private final List<OrCondition> orConditions = new ArrayList<OrCondition>();
    private final CTabFolder tabFolder = new CTabFolder((Composite)this, 2240);
    private final Button addOrConditionButton = this.creteAddOrConditionButton();

    public FilterAdvancedComposite(FilterChangedListener filterChangedListener, Composite parent, int style) {
        super(parent, style);
        this.addOrCondition();
        GridLayout layout = new GridLayout(1, true);
        layout.marginLeft = 6;
        layout.marginRight = 6;
        layout.marginTop = 6;
        layout.marginBottom = 6;
        layout.verticalSpacing = 12;
        this.setLayout((Layout)layout);
        GridData tabFolderLayoutData = new GridData();
        tabFolderLayoutData.horizontalAlignment = 4;
        tabFolderLayoutData.grabExcessHorizontalSpace = true;
        tabFolderLayoutData.verticalAlignment = 4;
        tabFolderLayoutData.grabExcessVerticalSpace = true;
        this.tabFolder.setLayoutData((Object)tabFolderLayoutData);
        this.tabFolder.setBackgroundMode(2);
        GridData addOrConditionButtonLayoutdata = new GridData();
        addOrConditionButtonLayoutdata.horizontalAlignment = 3;
        this.addOrConditionButton.setLayoutData((Object)addOrConditionButtonLayoutdata);
    }

    private Button creteAddOrConditionButton() {
        Button b = new Button((Composite)this, 8);
        b.setText(Messages.add_or_condition);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterAdvancedComposite.this.addOrCondition();
            }
        });
        b.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int i = FilterAdvancedComposite.this.tabFolder.getSelectionIndex();
                FilterAdvancedComposite.this.orConditions.remove(i);
            }
        });
        return b;
    }

    private void addOrCondition() {
        this.orConditions.add(new OrCondition(this, this.tabFolder));
        this.tabFolder.setSelection(this.tabFolder.getItemCount() - 1);
        this.refreshGUI();
    }

    private void refreshGUI() {
        this.layout(true, true);
    }

    private static class AddAssertionComposite
    extends Composite {
        private final OrCondition orCondition;
        private final Combo attributeCombo;

        public AddAssertionComposite(OrCondition orCondition, Composite parent) {
            super(parent, 0);
            this.orCondition = orCondition;
            this.attributeCombo = this.createAttributeCombo();
            this.createTypeCombo();
            this.createAddButton();
            RowLayout layout = new RowLayout();
            this.setLayout((Layout)layout);
        }

        private Combo createAttributeCombo() {
            Combo c = new Combo((Composite)this, 0);
            c.add("sourceTimestamp");
            c.add("entryTimestamp");
            Event.Fields[] fieldsArray = Event.Fields.values();
            int n = fieldsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Event.Fields field = fieldsArray[n2];
                c.add(field.getName());
                ++n2;
            }
            c.add(Messages.custom_field);
            c.select(0);
            return c;
        }

        private Combo createTypeCombo() {
            Combo c = new Combo((Composite)this, 0);
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                c.add(type.name());
                ++n2;
            }
            c.select(0);
            return c;
        }

        private Button createAddButton() {
            Button b = new Button((Composite)this, 8);
            b.setText(Messages.add_assertion);
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AddAssertionComposite.this.orCondition.addAssertion();
                }
            });
            return b;
        }
    }

    private static class AssertionComposite
    extends Composite {
        private final OrCondition orCondition;
        private final Button notCheck;
        private final Text attributeText;
        private final Text valueText;
        private final Combo assertionCombo;

        public AssertionComposite(OrCondition orCondition, Composite parent, String attribute, Type type) {
            super(parent, 0);
            this.orCondition = orCondition;
            this.notCheck = this.createNotCheck();
            this.attributeText = this.createAttributeText(attribute);
            this.createFieldTypeLabel(type);
            this.assertionCombo = this.createAssertionCombo();
            this.valueText = this.createValueText();
            this.createRemoveButton();
            RowLayout layout = new RowLayout();
            layout.center = true;
            this.setLayout((Layout)layout);
            parent.notifyListeners(11, new Event());
        }

        private Button createNotCheck() {
            Button b = new Button((Composite)this, 32);
            b.setText(Messages.not);
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AssertionComposite.this.orCondition.updateFilter();
                }
            });
            return b;
        }

        private Text createAttributeText(String attribute) {
            Text t = new Text((Composite)this, 2048);
            Event.Fields field = Event.Fields.byField((String)attribute);
            if (field == null) {
                t.setEditable(true);
                t.setMessage(Messages.custom_field);
            } else {
                t.setEditable(false);
                t.setText(field.getName());
            }
            t.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    AssertionComposite.this.orCondition.updateFilter();
                }
            });
            RowData rowData = new RowData();
            rowData.width = 132;
            t.setLayoutData((Object)rowData);
            return t;
        }

        private Label createFieldTypeLabel(Type type) {
            Label l = new Label((Composite)this, 0);
            l.setText(type.name());
            return l;
        }

        private Combo createAssertionCombo() {
            Combo c = new Combo((Composite)this, 0);
            Assertion[] assertionArray = Assertion.values();
            int n = assertionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Assertion assertion = assertionArray[n2];
                c.add(assertion.toString());
                ++n2;
            }
            c.select(0);
            c.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AssertionComposite.this.orCondition.updateFilter();
                }
            });
            RowData rowData = new RowData();
            rowData.width = 75;
            c.setLayoutData((Object)rowData);
            return c;
        }

        private Text createValueText() {
            Text t = new Text((Composite)this, 2048);
            t.setMessage(Messages.argument);
            t.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    AssertionComposite.this.orCondition.updateFilter();
                }
            });
            RowData rowData = new RowData();
            rowData.width = 132;
            t.setLayoutData((Object)rowData);
            return t;
        }

        private Button createRemoveButton() {
            Button b = new Button((Composite)this, 8);
            b.setText(Messages.remove);
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AssertionComposite.this.orCondition.removeAssertion(AssertionComposite.this);
                }
            });
            return b;
        }

        public Filter getExpression() {
            String attr = this.attributeText.getText();
            String ass = this.assertionCombo.getText();
            String val = this.valueText.getText();
            FilterAssertion assertion = new FilterAssertion(attr, Assertion.fromString((String)ass), (Object)val);
            if (val.contains("*")) {
                assertion.setAssertion(Assertion.SUBSTRING);
                assertion.setValue((Object)val.split("\\*"));
            }
            if (this.notCheck.getSelection()) {
                return FilterExpression.negate((Filter)assertion);
            }
            return assertion;
        }
    }

    private static class OrCondition {
        private final FilterAdvancedComposite filterAdvancedComposite;
        private final CTabItem tabItem;
        private final Composite tabContent;
        private final List<AssertionComposite> assertionComposites = new ArrayList<AssertionComposite>();
        private final AddAssertionComposite addAssertionComposite;
        private final ScrolledComposite assertionScrolledComposite;
        private final Composite assertionComposite;

        public OrCondition(FilterAdvancedComposite filterAdvancedComposite, CTabFolder tabFolder) {
            this.filterAdvancedComposite = filterAdvancedComposite;
            this.tabItem = new CTabItem(tabFolder, 0);
            this.tabItem.setText(Messages.a_condition);
            this.tabContent = new Composite((Composite)tabFolder, 0);
            this.tabItem.setControl((Control)this.tabContent);
            this.addAssertionComposite = new AddAssertionComposite(this, this.tabContent);
            this.assertionScrolledComposite = new ScrolledComposite(this.tabContent, 512);
            this.assertionComposite = new Composite((Composite)this.assertionScrolledComposite, 0);
            this.assertionScrolledComposite.setContent((Control)this.assertionComposite);
            GridLayout layout = new GridLayout();
            layout.marginLeft = 6;
            layout.marginRight = 6;
            layout.marginTop = 6;
            layout.marginBottom = 6;
            layout.verticalSpacing = 12;
            this.tabContent.setLayout((Layout)layout);
            GridData addAssertionCompositeLayoutData = new GridData();
            addAssertionCompositeLayoutData.grabExcessHorizontalSpace = true;
            addAssertionCompositeLayoutData.horizontalAlignment = 4;
            this.addAssertionComposite.setLayoutData(addAssertionCompositeLayoutData);
            GridData assertionCompositeLayoutData = new GridData();
            assertionCompositeLayoutData.grabExcessHorizontalSpace = true;
            assertionCompositeLayoutData.horizontalAlignment = 4;
            assertionCompositeLayoutData.grabExcessVerticalSpace = true;
            assertionCompositeLayoutData.verticalAlignment = 4;
            this.assertionScrolledComposite.setLayoutData((Object)assertionCompositeLayoutData);
            this.assertionScrolledComposite.setExpandHorizontal(true);
            RowLayout innerlayout = new RowLayout(512);
            innerlayout.wrap = false;
            this.assertionComposite.setLayout((Layout)innerlayout);
            this.assertionComposite.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Point s = OrCondition.this.assertionComposite.computeSize(-1, -1);
                    OrCondition.this.assertionComposite.setSize(s.x, s.y);
                    OrCondition.this.refreshGUI();
                }
            });
        }

        private void refreshGUI() {
            this.filterAdvancedComposite.refreshGUI();
        }

        public void addAssertion() {
            this.assertionComposites.add(new AssertionComposite(this, this.assertionComposite, this.addAssertionComposite.attributeCombo.getText(), Type.Text));
            this.refreshGUI();
            this.updateFilter();
        }

        public void removeAssertion(AssertionComposite assertion) {
            this.assertionComposites.remove((Object)assertion);
            assertion.dispose();
            this.refreshGUI();
            if (this.assertionComposites.size() == 0) {
                this.tabItem.setText(Messages.a_condition);
            }
        }

        public FilterExpression getExpression() {
            FilterExpression expression = new FilterExpression();
            expression.setOperator(Operator.AND);
            for (AssertionComposite assertionComposite : this.assertionComposites) {
                expression.getFilterSet().add(assertionComposite.getExpression());
            }
            return expression;
        }

        private void updateFilter() {
            this.tabItem.setText(this.getExpression().toString().replace("&", "&&"));
        }
    }

    private static enum Type {
        Text,
        Number,
        DateTime;

    }
}

