/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.connection.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.ca.client.FactoriesListener;
import org.eclipse.scada.ca.connection.provider.ConnectionService;
import org.eclipse.scada.ca.data.FactoryInformation;
import org.eclipse.scada.ca.ui.connection.data.FactoryInformationBean;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;

public class ConnectionWrapper
extends WritableSet
implements PropertyChangeListener {
    private final ConnectionHolder holder;
    private ConnectionService service;
    private final Map<String, FactoryInformationBean> entries = new HashMap<String, FactoryInformationBean>();
    private FactoriesListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper(ConnectionHolder target) {
        this.holder = target;
        ConnectionWrapper connectionWrapper = this;
        synchronized (connectionWrapper) {
            this.holder.addPropertyChangeListener("connectionService", (PropertyChangeListener)this);
            this.triggerUpdate();
        }
    }

    public synchronized void dispose() {
        this.holder.removePropertyChangeListener("connectionService", (PropertyChangeListener)this);
        super.dispose();
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        this.triggerUpdate();
    }

    private void triggerUpdate() {
        this.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionWrapper.this.update();
            }
        });
    }

    private void update() {
        this.setStale(true);
        try {
            ConnectionService service;
            this.clearConnection();
            this.service = service = (ConnectionService)this.holder.getConnectionService();
            if (this.service != null) {
                this.setupConnection();
            }
        }
        finally {
            this.setStale(false);
        }
    }

    private void setupConnection() {
        this.listener = new FactoriesListener(){

            public void updateFactories(FactoryInformation[] factories) {
                ConnectionWrapper.this.dataChanged(factories);
            }
        };
        this.service.getConnection().addFactoriesListener(this.listener);
    }

    private void clearConnection() {
        this.clear();
        for (FactoryInformationBean entry : this.entries.values()) {
            entry.dispose();
        }
        if (this.service != null) {
            this.service.getConnection().removeFactoriesListener(this.listener);
        }
        this.listener = null;
        this.handleDataChanged(new FactoryInformation[0]);
        this.entries.clear();
        this.service = null;
    }

    public ConnectionService getService() {
        return this.service;
    }

    public void dataChanged(final FactoryInformation[] factories) {
        this.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionWrapper.this.handleDataChanged(factories);
            }
        });
    }

    protected void handleDataChanged(FactoryInformation[] factories) {
        if (this.isDisposed()) {
            return;
        }
        this.setStale(true);
        try {
            this.clear();
            this.entries.clear();
            if (factories != null) {
                FactoryInformation[] factoryInformationArray = factories;
                int n = factories.length;
                int n2 = 0;
                while (n2 < n) {
                    FactoryInformation info = factoryInformationArray[n2];
                    FactoryInformationBean bean = new FactoryInformationBean(info, this.service);
                    this.entries.put(bean.getFactoryInformation().getId(), bean);
                    this.add((Object)bean);
                    ++n2;
                }
            }
        }
        finally {
            this.setStale(false);
        }
    }
}

