/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.controller;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.scada.ui.chart.model.Controller;
import org.eclipse.scada.ui.chart.viewer.ChartContext;
import org.eclipse.scada.ui.chart.viewer.controller.ChartController;
import org.eclipse.scada.ui.chart.viewer.controller.ChartControllerFactory;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;

public class ControllerManager {
    private final WritableList list;
    private final DataBindingContext ctx;
    private final ChartContext chartContext;
    private final Realm realm;
    private final Map<Controller, ChartController> controllerMap = new HashMap<Controller, ChartController>();

    public ControllerManager(DataBindingContext ctx, Realm realm, ChartContext chartContext) {
        this.ctx = ctx;
        this.realm = realm;
        this.chartContext = chartContext;
        this.list = new WritableList();
        this.list.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                ControllerManager.this.handleChange(event.diff);
            }
        });
    }

    protected void handleChange(ListDiff diff) {
        diff.accept(new ListDiffVisitor(){

            public void handleRemove(int index, Object element) {
                ControllerManager.this.handleRemove((Controller)element);
            }

            public void handleAdd(int index, Object element) {
                ControllerManager.this.handleAdd((Controller)element);
            }
        });
    }

    protected void handleAdd(Controller controller) {
        this.handleRemove(controller);
        ChartController chartController = this.createController(controller);
        if (chartController != null) {
            this.controllerMap.put(controller, chartController);
        }
        this.chartContext.relayoutExtensionSpace();
    }

    protected void handleRemove(Controller controller) {
        ChartController chartController = this.controllerMap.get(controller);
        if (chartController != null) {
            chartController.dispose();
        }
        this.chartContext.relayoutExtensionSpace();
    }

    private ChartControllerFactory createFactory(Controller controller) {
        ChartControllerFactory factory = (ChartControllerFactory)AdapterHelper.adapt((Object)controller, ChartControllerFactory.class);
        if (factory != null) {
            return factory;
        }
        return null;
    }

    private ChartController createController(Controller controller) {
        ChartControllerFactory factory = this.createFactory(controller);
        if (factory == null) {
            return null;
        }
        return factory.create(this, controller, this.chartContext);
    }

    public WritableList getList() {
        return this.list;
    }

    public void dispose() {
        for (ChartController chartController : this.controllerMap.values()) {
            chartController.dispose();
        }
        this.controllerMap.clear();
        this.list.dispose();
    }

    public DataBindingContext getContext() {
        return this.ctx;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public ChartContext getChartContext() {
        return this.chartContext;
    }
}

