/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.chart.viewer.input;

import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.DataEntry;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.WritableSeries;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.render.AbstractLineRender;
import org.eclipse.scada.chart.swt.render.PositionYRuler;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.scada.chart.swt.render.StepRenderer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.ui.connection.data.DataItemHolder;
import org.eclipse.scada.da.ui.connection.data.DataSourceListener;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.eclipse.scada.ui.chart.Activator;
import org.eclipse.scada.ui.chart.viewer.ChartViewer;
import org.eclipse.scada.ui.chart.viewer.input.LineInput;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.RGB;

public class ItemObserver
extends LineInput
implements DataSourceListener {
    private static final String PROP_STATE = "state";
    private final Item item;
    private final WritableSeries valueSeries;
    private DataItemHolder dataItem;
    private DataItemValue lastValue;
    private DataEntry lastTickMarker;
    private final StepRenderer valueRenderer;
    private boolean selection;
    private final YAxis y;
    private final Collection<LevelRuler> levelRulers = new LinkedList<LevelRuler>();
    private final ChartViewer viewer;
    private boolean disposed;
    private SubscriptionState state;
    private Calendar originalSelectedTimestamp;

    public ItemObserver(ChartViewer viewer, Item item, Realm realm, XAxis x, YAxis y, ResourceManager resourceManager) {
        super(resourceManager);
        this.item = item;
        this.viewer = viewer;
        this.y = y;
        this.valueSeries = new WritableSeries(realm, x, y);
        this.valueRenderer = new StepRenderer(viewer.getChartRenderer(), (SeriesData)this.valueSeries);
        viewer.getChartRenderer().addRenderer((Renderer)this.valueRenderer, 0);
        this.connect();
        this.attachHover(viewer, x);
    }

    @Override
    protected AbstractLineRender getLineRenderer() {
        return this.valueRenderer;
    }

    @Override
    public void setSelection(boolean state) {
        if (this.selection == state) {
            return;
        }
        this.selection = state;
        if (this.selection) {
            this.levelRulers.add(this.makeLevelRuler("org.eclipse.scada.da.level.ceil", 0, 255, 2.0f));
            this.levelRulers.add(this.makeLevelRuler("org.eclipse.scada.da.level.highhigh", 128, 64, 1.0f));
            this.levelRulers.add(this.makeLevelRuler("org.eclipse.scada.da.level.high", 128, 32, 1.0f));
            this.levelRulers.add(this.makeLevelRuler("org.eclipse.scada.da.level.low", 1024, 32, 1.0f));
            this.levelRulers.add(this.makeLevelRuler("org.eclipse.scada.da.level.lowlow", 1024, 64, 1.0f));
            this.levelRulers.add(this.makeLevelRuler("org.eclipse.scada.da.level.floor", 0, 255, 2.0f));
            this.updateLevels();
        } else {
            this.removeLevelRulers();
        }
    }

    private void updateLevels() {
        for (LevelRuler ruler : this.levelRulers) {
            ruler.update(this.lastValue);
        }
    }

    private LevelRuler makeLevelRuler(String prefix, int style, int alpha, float lineWidth) {
        LevelRuler ruler = new LevelRuler(this.viewer.getChartRenderer(), prefix, this.y, style, alpha, lineWidth);
        return ruler;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            this.disposed = true;
        }
        this.removeLevelRulers();
        this.viewer.removeInput(this);
        this.viewer.getChartRenderer().removeRenderer((Renderer)this.valueRenderer);
        this.valueRenderer.dispose();
        this.disconnect();
    }

    private void removeLevelRulers() {
        for (LevelRuler ruler : this.levelRulers) {
            ruler.dispose();
        }
        this.levelRulers.clear();
    }

    public Item getItem() {
        return this.item;
    }

    @Override
    public boolean tick(long now) {
        if (this.lastTickMarker == null) {
            DataEntry newMarker = this.makeEntry(this.lastValue);
            if (newMarker.getTimestamp() > now) {
                return false;
            }
            this.lastTickMarker = newMarker;
        } else {
            this.valueSeries.getData().remove(this.lastTickMarker);
        }
        this.lastTickMarker = new DataEntry(now, this.lastTickMarker.getValue());
        this.valueSeries.getData().add(this.lastTickMarker);
        return true;
    }

    public void connect() {
        this.dataItem = new DataItemHolder(Activator.getDefault().getBundle().getBundleContext(), this.item, (DataSourceListener)this);
    }

    public void disconnect() {
        if (this.dataItem != null) {
            this.dataItem.dispose();
            this.dataItem = null;
        }
    }

    public void updateData(final DataItemValue value) {
        if (!this.valueSeries.getRealm().isDisposed()) {
            this.valueSeries.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ItemObserver.this.updateState(value);
                    ItemObserver.this.addNewValue(value);
                }
            });
        }
    }

    protected void updateState(DataItemValue value) {
        if (value != null && this.state != value.getSubscriptionState()) {
            this.state = value.getSubscriptionState();
            this.firePropertyChange(PROP_STATE, this.state, this.state);
        }
    }

    private void addNewValue(DataItemValue value) {
        this.lastValue = value;
        if (this.lastTickMarker != null) {
            this.valueSeries.getData().remove(this.lastTickMarker);
            this.lastTickMarker = null;
        }
        DataEntry entry = this.makeEntry(value);
        this.valueSeries.getData().addAsLast(entry);
        this.updateLevels();
        this.setSelection(this.originalSelectedTimestamp);
    }

    private DataEntry makeEntry(DataItemValue value) {
        if (value == null || value.isError() || !value.isConnected() || value.getValue() == null) {
            return new DataEntry(System.currentTimeMillis(), null);
        }
        Calendar valueTimestamp = value.getTimestamp();
        long timestamp = valueTimestamp == null ? System.currentTimeMillis() : valueTimestamp.getTimeInMillis();
        return new DataEntry(timestamp, value.getValue().asDouble(null));
    }

    @Override
    public String getState() {
        SubscriptionState state = this.state;
        return state == null ? null : state.name();
    }

    @Override
    protected void setSelectedTimestamp(Calendar selectedTimestamp) {
        if (selectedTimestamp == null) {
            return;
        }
        this.originalSelectedTimestamp = selectedTimestamp;
        if (this.valueSeries == null || this.valueSeries.getData() == null) {
            return;
        }
        DataEntry value = this.valueSeries.getData().getEntries().lower(new DataEntry(selectedTimestamp.getTimeInMillis(), null));
        if (value == null) {
            this.setSelectedValue(null);
            super.setSelectedTimestamp(null);
            this.setSelectedQuality(0.0);
        } else {
            this.setSelectedValue(value.getValue());
            this.setSelectedQuality(value.getValue() == null ? 0.0 : 1.0);
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(value.getTimestamp());
            super.setSelectedTimestamp(c);
        }
    }

    private static class LevelRuler {
        private final String prefix;
        private final PositionYRuler ruler;
        private final ChartRenderer manager;
        private final int alpha;

        public LevelRuler(ChartRenderer manager, String prefix, YAxis y, int style, int alpha, float lineWidth) {
            this.prefix = prefix;
            this.manager = manager;
            this.alpha = alpha;
            this.ruler = new PositionYRuler(y, style);
            this.ruler.setAlpha(this.alpha);
            this.ruler.setLineAttributes(new LineAttributes(lineWidth));
            this.manager.addRenderer((Renderer)this.ruler, 200);
        }

        public void dispose() {
            this.manager.removeRenderer((Renderer)this.ruler);
        }

        public void update(DataItemValue value) {
            this.ruler.setVisible(false);
            if (value != null) {
                Variant levelValue = (Variant)value.getAttributes().get(String.valueOf(this.prefix) + ".preset");
                if (levelValue != null) {
                    this.ruler.setPosition(levelValue.asDouble(null));
                    this.ruler.setVisible(true);
                }
                boolean active = value.getAttributeAsBoolean(String.valueOf(this.prefix) + ".active");
                boolean unsafe = value.getAttributeAsBoolean(String.valueOf(this.prefix) + ".unsafe");
                boolean error = value.getAttributeAsBoolean(String.valueOf(this.prefix) + ".error");
                boolean alarm = value.getAttributeAsBoolean(String.valueOf(this.prefix) + ".alarm");
                if (!active) {
                    this.ruler.setColor(new RGB(128, 128, 128));
                } else if (unsafe) {
                    this.ruler.setColor(new RGB(255, 0, 255));
                } else if (error || alarm) {
                    this.ruler.setColor(new RGB(255, 0, 0));
                } else {
                    this.ruler.setColor(new RGB(0, 255, 0));
                }
            }
        }
    }
}

