/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.information;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.scada.core.connection.provider.info.ConnectionInformationProvider;
import org.eclipse.scada.core.ui.connection.information.Activator;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionInformationList {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionInformationList.class);
    private final WritableSet list;
    private final Map<ServiceReference<?>, Object> objectMap = new HashMap();
    private ServiceListener listener;
    private final BundleContext context = Activator.getDefault().getBundle().getBundleContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionInformationList() {
        ConnectionInformationList connectionInformationList = this;
        synchronized (connectionInformationList) {
            try {
                this.listener = new ServiceListener(){

                    public void serviceChanged(ServiceEvent event) {
                        ConnectionInformationList.this.handleServiceChanged(event);
                    }
                };
                this.context.addServiceListener(this.listener, FilterUtil.createClassFilter((String)ConnectionInformationProvider.class.getName()).toString());
            }
            catch (InvalidSyntaxException e) {
                logger.warn("Failed to create filter expression", (Throwable)e);
            }
            this.list = new WritableSet(SWTObservables.getRealm((Display)Display.getDefault()));
            try {
                ServiceReference[] refs = this.context.getAllServiceReferences(ConnectionInformationProvider.class.getName(), null);
                if (refs != null) {
                    this.addInitialServices(refs);
                }
            }
            catch (InvalidSyntaxException e) {
                logger.warn("Failed to search services", (Throwable)e);
            }
        }
    }

    protected synchronized void handleServiceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 4: 
            case 8: {
                this.removeService(event.getServiceReference());
                break;
            }
            case 1: {
                this.addService(event.getServiceReference());
            }
        }
    }

    private synchronized void removeService(ServiceReference<?> serviceReference) {
        final Object old = this.objectMap.remove(serviceReference);
        if (old != null) {
            this.context.ungetService(serviceReference);
            this.list.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ConnectionInformationList.this.list.remove(old);
                }
            });
        }
    }

    private synchronized void addInitialServices(ServiceReference<?>[] refs) {
        HashMap connections = new HashMap();
        ServiceReference<?>[] serviceReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<?> serviceReference = serviceReferenceArray[n2];
            Object o = this.context.getService(serviceReference);
            if (!(o instanceof ConnectionInformationProvider)) {
                this.context.ungetService(serviceReference);
            } else {
                connections.put(serviceReference, o);
            }
            ++n2;
        }
        this.objectMap.putAll(connections);
        this.list.addAll(connections.values());
    }

    private synchronized void addService(ServiceReference<?> serviceReference) {
        final Object o = this.context.getService(serviceReference);
        if (!(o instanceof ConnectionInformationProvider)) {
            this.context.ungetService(serviceReference);
            return;
        }
        final Object old = this.objectMap.put(serviceReference, o);
        this.list.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionInformationList.this.addService(o, old);
            }
        });
    }

    private void addService(Object o, Object old) {
        if (this.list.isDisposed()) {
            return;
        }
        try {
            this.list.setStale(true);
            if (old != null) {
                this.list.remove(old);
            }
            this.list.add(o);
        }
        finally {
            this.list.setStale(false);
        }
    }

    public IObservableSet getList() {
        return this.list;
    }

    public void dispose() {
        this.context.removeServiceListener(this.listener);
        for (ServiceReference<?> ref : this.objectMap.keySet()) {
            this.context.ungetService(ref);
        }
        if (!this.list.isDisposed()) {
            this.list.clear();
            this.list.dispose();
        }
    }
}

