/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.ui.data.AbstractQueryBuffer;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryViewPart
extends ViewPart
implements QueryListener {
    private static final Logger logger = LoggerFactory.getLogger(QueryViewPart.class);
    protected volatile AbstractQueryBuffer query;
    private ISelectionListener selectionListener;

    public void dispose() {
        this.removeListener();
        this.clear();
        super.dispose();
    }

    protected void addListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    QueryViewPart.this.setSelection(selection);
                }
            };
            this.getViewSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        }
    }

    protected void removeListener() {
        if (this.selectionListener != null) {
            this.getViewSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    protected AbstractQueryBuffer getQueryFromSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object o = ((IStructuredSelection)selection).getFirstElement();
        if (o instanceof AbstractQueryBuffer) {
            return (AbstractQueryBuffer)((Object)o);
        }
        return null;
    }

    protected void setSelection(ISelection selection) {
        AbstractQueryBuffer query = this.getQueryFromSelection(selection);
        if (query != this.query) {
            this.clear();
            if (query != null) {
                this.setQuery(query);
            }
        }
    }

    protected void setQuery(AbstractQueryBuffer query) {
        logger.info("Setting query: {}", (Object)query);
        this.query = query;
        this.query.addQueryListener(this);
    }

    protected void clear() {
        logger.info("Clearing query");
        if (this.query != null) {
            this.query.removeQueryListener(this);
            this.query = null;
        }
    }
}

