/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.Query;
import org.eclipse.scada.ae.QueryListener;
import org.eclipse.scada.ae.data.QueryState;
import org.eclipse.scada.ae.ui.views.Activator;
import org.eclipse.scada.ae.ui.views.CustomizableAction;
import org.eclipse.scada.ae.ui.views.config.ColumnLabelProviderInformation;
import org.eclipse.scada.ae.ui.views.config.ConfigurationHelper;
import org.eclipse.scada.ae.ui.views.config.EventHistoryViewConfiguration;
import org.eclipse.scada.ae.ui.views.dialog.EventHistorySearchDialog;
import org.eclipse.scada.ae.ui.views.dialog.SearchType;
import org.eclipse.scada.ae.ui.views.model.DecoratedEvent;
import org.eclipse.scada.ae.ui.views.views.AbstractAlarmsEventsView;
import org.eclipse.scada.ae.ui.views.views.ColumnProperties;
import org.eclipse.scada.ae.ui.views.views.EventViewTable;
import org.eclipse.scada.ae.ui.views.views.Messages;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.eclipse.scada.utils.lang.Pair;
import org.eclipse.scada.utils.str.StringHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHistoryView
extends AbstractAlarmsEventsView {
    private static final Logger logger = LoggerFactory.getLogger(EventHistoryView.class);
    public static final String ID = "org.eclipse.scada.ae.ui.views.views.eventhistory";
    private static final int LOAD_NO_OF_ITEMS = 2000;
    private CustomizableAction clearAction;
    private CustomizableAction searchAction;
    private CustomizableAction resumeAction;
    private EventViewTable eventsTable;
    private Pair<SearchType, String> currentFilter;
    private final AtomicReference<Query> queryRef = new AtomicReference<Object>(null);
    private final AtomicReference<QueryState> queryState = new AtomicReference<QueryState>(QueryState.DISCONNECTED);
    private final AtomicReference<Throwable> queryError = new AtomicReference<Object>(null);
    private ScheduledExecutorService scheduler;
    private final AtomicInteger noOfEvents = new AtomicInteger(0);
    private final AtomicBoolean isPaused = new AtomicBoolean(false);
    private WritableSet events;
    private List<ColumnProperties> initialColumnSettings;
    private final Gson gson = new GsonBuilder().create();
    private List<ColumnLabelProviderInformation> columnInformations;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.scheduler = ScheduledExportedExecutorService.newSingleThreadExportedScheduledExecutor((String)("org.eclipse.scada.ae.ui.views.views.eventhistory/" + this.getViewSite().getSecondaryId()));
        this.resumeAction = new CustomizableAction();
        this.resumeAction.setText(Messages.EventHistoryView_Action_Resume_Text);
        this.resumeAction.setToolTipText(Messages.EventHistoryView_Action_Resume_ToolTop);
        this.resumeAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/resume.gif")));
        this.resumeAction.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/resume_disabled.gif")));
        this.resumeAction.setEnabled(false);
        this.resumeAction.setRunnable(new Runnable(){

            @Override
            public void run() {
                EventHistoryView.this.resumeEventsRetrieval();
            }
        });
        this.clearAction = new CustomizableAction();
        this.clearAction.setText(Messages.EventHistoryView_Action_Clear_Text);
        this.clearAction.setToolTipText(Messages.EventHistoryView_Action_Clear_ToolTip);
        this.clearAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/clear_search.gif")));
        this.clearAction.setEnabled(false);
        this.clearAction.setRunnable(new Runnable(){

            @Override
            public void run() {
                EventHistoryView.this.clearData();
                EventHistoryView.this.searchAction.setChecked(false);
            }
        });
        this.searchAction = new CustomizableAction("", 2);
        this.searchAction.setText(Messages.EventHistoryView_Action_Search_Text);
        this.searchAction.setToolTipText(Messages.EventHistoryView_Action_Search_ToolTip);
        this.searchAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/search.gif")));
        this.searchAction.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/search_disabled.gif")));
        this.searchAction.setEnabled(false);
        this.searchAction.setRunnable(new Runnable(){

            @Override
            public void run() {
                EventHistoryView.this.searchAction.setChecked(true);
                EventHistoryView.this.pauseEventsRetrieval();
                EventHistoryView.this.startEventsRetrieval();
            }
        });
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.resumeAction);
        toolBarManager.add((IAction)this.searchAction);
        toolBarManager.add((IAction)this.clearAction);
        this.events = new WritableSet(DisplayRealm.getRealm((Display)parent.getDisplay()));
        this.loadConfiguration();
        this.eventsTable = new EventViewTable(this.getContentPane(), this.getViewSite(), 2048, this.events, this.initialColumnSettings, this.columnInformations);
        this.eventsTable.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.getSite().setSelectionProvider((ISelectionProvider)this.eventsTable.getTableViewer());
    }

    private void loadConfiguration() {
        EventHistoryViewConfiguration cfg = ConfigurationHelper.findEventHistoryViewConfiguration(this.getViewSite().getSecondaryId());
        if (cfg != null) {
            try {
                this.setConfiguration(cfg);
            }
            catch (Exception e) {
                logger.warn("Failed to apply configuration", (Throwable)e);
            }
        } else {
            logger.info("no configuration found");
        }
    }

    protected void setConfiguration(EventHistoryViewConfiguration cfg) throws Exception {
        switch (cfg.getConnectionType()) {
            case URI: {
                this.setConnectionUri(cfg.getConnectionString());
                break;
            }
            case ID: {
                this.setConnectionId(cfg.getConnectionString());
            }
        }
        if (cfg.getLabel() != null) {
            this.setPartName(cfg.getLabel());
        }
        this.columnInformations = cfg.getColumnInformation();
    }

    public void setFocus() {
        this.eventsTable.setFocus();
    }

    @Override
    protected Realm getRealm() {
        if (this.events != null) {
            return this.events.getRealm();
        }
        return DisplayRealm.getRealm((Display)this.getSite().getShell().getDisplay());
    }

    @Override
    protected void onConnect() {
        super.onConnect();
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EventHistoryView.this.resumeAction.setEnabled(false);
                EventHistoryView.this.clearAction.setEnabled(true);
                EventHistoryView.this.searchAction.setEnabled(true);
            }
        });
    }

    @Override
    protected void onDisconnect() {
        super.onDisconnect();
        try {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EventHistoryView.this.clearData();
                    EventHistoryView.this.resumeAction.setEnabled(false);
                    EventHistoryView.this.clearAction.setEnabled(false);
                    EventHistoryView.this.searchAction.setEnabled(false);
                }
            });
        }
        catch (Exception exception) {}
    }

    private void clearData() {
        this.cancelQuery();
        this.noOfEvents.set(0);
        this.eventsTable.clear();
        this.resumeAction.setEnabled(false);
        this.clearAction.setEnabled(true);
        this.searchAction.setEnabled(true);
        this.updateStatusBar();
    }

    private void startEventsRetrieval() {
        Pair<SearchType, String> filter = EventHistorySearchDialog.open(this.getSite().getShell(), this.currentFilter);
        if (filter != null) {
            this.currentFilter = filter;
            this.retrieveData((String)filter.second);
            this.resumeAction.setEnabled(false);
        }
    }

    private void pauseEventsRetrieval() {
        this.isPaused.set(true);
        if (this.queryRef.get() != null) {
            this.resumeAction.setEnabled(true);
        }
    }

    private void resumeEventsRetrieval() {
        this.isPaused.set(false);
        this.continueLoading();
        this.resumeAction.setEnabled(false);
    }

    private void retrieveData(String filter) {
        QueryListener queryListener = new QueryListener(){

            public void queryStateChanged(QueryState state, Throwable error) {
                EventHistoryView.this.queryError.set(error);
                EventHistoryView.this.queryState.set(state);
                if (state == QueryState.CONNECTED && !EventHistoryView.this.isPaused.get()) {
                    EventHistoryView.this.resumeAction.setEnabled(true);
                } else if (state == QueryState.DISCONNECTED) {
                    EventHistoryView.this.queryRef.set(null);
                    EventHistoryView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
                EventHistoryView.this.updateStatusBar();
            }

            public void queryData(List<Event> events) {
                LinkedHashSet<DecoratedEvent> decoratedEvents;
                if (events == null) {
                    decoratedEvents = new LinkedHashSet<DecoratedEvent>();
                } else {
                    decoratedEvents = new LinkedHashSet(events.size() + 1);
                    for (Event event : events) {
                        decoratedEvents.add(new DecoratedEvent(event));
                    }
                }
                EventHistoryView.this.noOfEvents.addAndGet(decoratedEvents.size());
                EventHistoryView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EventHistoryView.this.updateStatusBar();
                        for (DecoratedEvent decoratedEvent : decoratedEvents) {
                            EventHistoryView.this.events.add((Object)decoratedEvent);
                        }
                    }
                });
            }
        };
        this.clearData();
        if (this.isConnected()) {
            this.isPaused.set(false);
            this.queryRef.set(this.getConnection().createQuery("client", filter, queryListener));
        }
    }

    private void cancelQuery() {
        this.isPaused.set(true);
        if (this.queryRef.get() != null) {
            this.queryRef.get().close();
        }
        this.queryRef.set(null);
    }

    private void continueLoading() {
        this.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                if (EventHistoryView.this.queryRef.get() != null) {
                    ((Query)EventHistoryView.this.queryRef.get()).loadMore(2000);
                }
            }
        }, 50L, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void updateStatusBar() {
        this.scheduleJob(new Runnable(){

            @Override
            public void run() {
                EventHistoryView.this.getStateLabel().setText(EventHistoryView.this.createStatusLabel());
                Throwable error = (Throwable)EventHistoryView.this.queryError.get();
                EventHistoryView.this.getStateLabel().setToolTipText(error != null ? error.getMessage() : null);
            }
        });
    }

    protected String createStatusLabel() {
        LinkedList<String> labels = new LinkedList<String>();
        labels.add(this.getLabelForConnection());
        if (this.currentFilter != null) {
            labels.add(String.format(Messages.EventHistoryView_Label_Format_Filter, ((String)this.currentFilter.second).replace("&", "&&")));
        }
        if (this.queryState.get() == QueryState.LOADING) {
            labels.add(Messages.EventHistoryView_Label_Format_IsLoading);
        }
        labels.add(String.format(Messages.EventHistoryView_Label_Format_CountEvents, this.events.size()));
        return StringHelper.join(labels, (String)Messages.EventHistoryView_Sep);
    }

    @Override
    protected void watchPool(String poolId) {
    }

    @Override
    protected void watchMonitors(String monitorsId) {
    }

    @Override
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String s;
        super.init(site, memento);
        if (memento != null && (s = memento.getString("columnSettings")) != null) {
            this.initialColumnSettings = (List)this.gson.fromJson(s, new TypeToken<List<ColumnProperties>>(){}.getType());
        }
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putString("columnSettings", this.gson.toJson(this.eventsTable.getColumnSettings()));
        super.saveState(memento);
    }
}

