/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Orientation implements Enumerator
{
    NORTH(0, "NORTH", "NORTH"),
    SOUTH(1, "SOUTH", "SOUTH"),
    EAST(2, "EAST", "EAST"),
    WEST(3, "WEST", "WEST");

    public static final int NORTH_VALUE = 0;
    public static final int SOUTH_VALUE = 1;
    public static final int EAST_VALUE = 2;
    public static final int WEST_VALUE = 3;
    private static final Orientation[] VALUES_ARRAY;
    public static final List<Orientation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Orientation[]{NORTH, SOUTH, EAST, WEST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Orientation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Orientation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Orientation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Orientation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Orientation get(int value) {
        switch (value) {
            case 0: {
                return NORTH;
            }
            case 1: {
                return SOUTH;
            }
            case 2: {
                return EAST;
            }
            case 3: {
                return WEST;
            }
        }
        return null;
    }

    private Orientation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

