/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers.pkcs12;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.scada.sec.ui.providers.KeyProvider;
import org.eclipse.scada.sec.ui.providers.KeyProviderFactory;
import org.eclipse.scada.sec.ui.providers.KeyTreeViewer;
import org.eclipse.scada.sec.ui.providers.Locked;
import org.eclipse.scada.sec.ui.providers.pkcs12.FactoryImpl;
import org.eclipse.scada.ui.utils.SelectionHelper;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePage
extends org.eclipse.jface.preference.PreferencePage
implements IWorkbenchPreferencePage {
    private FactoryImpl factory;
    private KeyTreeViewer viewer;
    private Button addButton;
    private Button removeButton;
    private List<KeyProvider> selectedProviders;
    private Button unlockButton;
    private List<Locked> locked;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        wrapper.setLayout((Layout)new GridLayout(1, false));
        this.factory = new FactoryImpl();
        this.factory.init(SWTObservables.getRealm((Display)parent.getDisplay()));
        this.viewer = new KeyTreeViewer(wrapper);
        this.viewer.setInput((KeyProviderFactory)this.factory);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttons = new Composite(wrapper, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        buttons.setLayout((Layout)new RowLayout(256));
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("Add\u2026");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePage.this.handleAdd();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText("Remove");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePage.this.handleRemove();
            }
        });
        this.unlockButton = new Button(buttons, 8);
        this.unlockButton.setText("Unlock");
        this.unlockButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePage.this.handleUnlock();
            }
        });
        this.viewer.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PreferencePage.this.setSelection(event.getSelection());
            }
        });
        this.setSelection((ISelection)StructuredSelection.EMPTY);
        return wrapper;
    }

    protected void handleUnlock() {
        try {
            for (Locked l : this.locked) {
                l.unlock((CallbackHandler)new DisplayCallbackHandler(this.getShell(), "Unlock", "Unlock key element"));
            }
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", null, (IStatus)StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers.pkcs12", (Throwable)e));
        }
    }

    protected void setSelection(ISelection selection) {
        this.selectedProviders = SelectionHelper.list((ISelection)selection, KeyProvider.class);
        this.locked = SelectionHelper.list((ISelection)selection, Locked.class);
        this.unlockButton.setEnabled(!this.locked.isEmpty());
        this.removeButton.setEnabled(!this.selectedProviders.isEmpty());
    }

    protected void handleRemove() {
        MultiStatus ms = new MultiStatus("org.eclipse.scada.sec.ui.providers.pkcs12", 0, "Removing key providers", null);
        for (KeyProvider provider : this.selectedProviders) {
            try {
                this.factory.remove(provider);
            }
            catch (Exception e) {
                ms.add(StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers.pkcs12", (Throwable)e));
            }
        }
        if (!ms.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", null, (IStatus)ms);
        }
    }

    protected void handleAdd() {
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        String result = dlg.open();
        if (result != null) {
            try {
                this.factory.addFile(result);
            }
            catch (Exception e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Failed to add file", (IStatus)StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers.pkcs12", (Throwable)e));
            }
        }
    }
}

