/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.ui.providers.internal;

import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.scada.sec.authz.signature.RequestSigner;
import org.eclipse.scada.sec.authz.signature.SignatureRequestBuilder;
import org.eclipse.scada.sec.callback.XMLSignatureCallback;
import org.eclipse.scada.sec.ui.CallbackWidgetFactory;
import org.eclipse.scada.sec.ui.providers.KeyInformation;
import org.eclipse.scada.sec.ui.providers.KeyInstanceManager;
import org.eclipse.scada.sec.ui.providers.KeySelectorDialog;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;
import org.w3c.dom.Document;

public class XMLSignatureWidgetFactory
implements CallbackWidgetFactory {
    private final XMLSignatureCallback callback;
    private Text text;

    public XMLSignatureWidgetFactory(XMLSignatureCallback callback) {
        this.callback = callback;
    }

    public void createGridWidgets(DataBindingContext dbc, final Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Certificate:");
        Composite wrapper = new Composite(composite, 0);
        wrapper.setLayout((Layout)new GridLayout(2, false));
        wrapper.setLayoutData((Object)new GridData(4, 4, true, false));
        this.text = new Text(wrapper, 2056);
        this.text.setEnabled(false);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setKeyCert(null);
        Button button = new Button(wrapper, 8);
        button.setText("Select key");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLSignatureWidgetFactory.this.openDialog(composite.getShell());
            }
        });
        button.setLayoutData((Object)new GridData(4, 1, false, false));
    }

    protected void openDialog(Shell shell) {
        KeySelectorDialog dlg = new KeySelectorDialog(shell, "Select Key", "Select a key for signing", this.callback.getMaximumRememberPeriod() / 60000);
        if (dlg.open() == 0) {
            KeyInformation ki = dlg.getKeyInformation();
            this.setKeyCert(ki);
            this.sign(ki.getKey(), ki.getCertificate());
        } else {
            this.setKeyCert(null);
        }
    }

    private void setKeyCert(KeyInformation ki) {
        if (ki == null) {
            this.text.setText("<none>");
            return;
        }
        Certificate certificate = ki.getCertificate();
        Key key = ki.getKey();
        if (certificate instanceof X509Certificate) {
            this.text.setText("" + ((X509Certificate)certificate).getSubjectX500Principal());
        } else {
            this.text.setText(String.format("%s - %s - %s", ki.getAlias(), key.getFormat(), key.getAlgorithm()));
        }
    }

    private void sign(Key key, Certificate cert) {
        try {
            this.performSign(key, cert);
        }
        catch (Exception e) {
            IStatus status = StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers", (Throwable)e);
            StatusManager.getManager().handle(status);
            ErrorDialog.openError((Shell)this.text.getShell(), (String)"Error", (String)"Error signing", (IStatus)status);
        }
    }

    private void performSign(Key key, Certificate cert) throws Exception {
        SignatureRequestBuilder builder = new SignatureRequestBuilder();
        Document doc = builder.fromString(this.callback.getDocument());
        RequestSigner.Configuration cfg = new RequestSigner.Configuration();
        cfg.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        new RequestSigner(cfg).sign(key, cert, doc);
        this.callback.setSignedDocument(builder.toString(doc, false));
    }

    public void complete() {
    }

    public boolean tryInstantComplete() {
        KeyInstanceManager mgr = KeyInstanceManager.getInstance(Display.getCurrent());
        if (mgr == null) {
            return false;
        }
        KeyInformation key = mgr.getDefaultKey();
        if (key == null) {
            return false;
        }
        try {
            this.performSign(key.getKey(), key.getCertificate());
            return true;
        }
        catch (Exception e) {
            mgr.clearDefaultKey();
            StatusManager.getManager().handle(StatusHelper.convertStatus((String)"org.eclipse.scada.sec.ui.providers", (Throwable)e));
            return false;
        }
    }
}

