/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.ui.connection.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.da.client.FolderManager;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.browser.DataItemEntry;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.browser.FolderEntry;
import org.eclipse.scada.da.ui.connection.data.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderEntryWrapper
implements IAdaptable {
    private static final Logger logger = LoggerFactory.getLogger(FolderEntryWrapper.class);
    private final FolderManager folderManager;
    private final FolderEntryWrapper parent;
    private final Entry entry;
    private final Location location;
    private final ConnectionHolder holder;

    public FolderEntryWrapper(ConnectionHolder holder, FolderManager folderManager) {
        this.holder = holder;
        this.folderManager = folderManager;
        this.parent = null;
        this.entry = null;
        this.location = Location.ROOT;
    }

    public FolderEntryWrapper(FolderEntryWrapper parent, Entry entry, Location location) {
        this.holder = parent.getHolder();
        this.folderManager = parent.getFolderManager();
        this.parent = parent;
        this.entry = entry;
        this.location = location;
        logger.info("Create new folder entry wrapper {} ", (Object)this);
    }

    protected ConnectionHolder getHolder() {
        return this.holder;
    }

    public Location getLocation() {
        return this.location;
    }

    public FolderManager getFolderManager() {
        return this.folderManager;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public FolderEntryWrapper getParent() {
        return this.parent;
    }

    public Object getAdapter(Class adapter) {
        logger.debug("Adapt to: {}", (Object)adapter);
        if (adapter == FolderEntry.class && this.entry instanceof FolderEntry) {
            return this.entry;
        }
        if (adapter == DataItemEntry.class && this.entry instanceof DataItemEntry) {
            return this.entry;
        }
        if (adapter == Item.class && this.entry instanceof DataItemEntry) {
            DataItemEntry entry = (DataItemEntry)this.entry;
            return new Item(this.getHolder().getConnectionInformation().getConnectionInformation().toString(), entry.getId(), Item.Type.URI);
        }
        return null;
    }

    public String toString() {
        return String.format("%s -> %s", this.holder.getConnectionInformation(), this.location);
    }
}

