/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.styles;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public interface StyleHandler {
    public void setStyle(Style var1);

    public static class RGBInformation {
        private final RGB rgb;

        public RGBInformation(RGB rgb) {
            this.rgb = rgb;
        }

        public String toHex() {
            return String.format("#%02x%02x%02x", this.rgb.red, this.rgb.green, this.rgb.blue);
        }

        public String toString() {
            return this.toHex();
        }
    }

    public static class Style {
        public Image[] images;
        public Color[] foregroundColor;
        public Color[] backgroundColor;
        public Font[] font;

        public Style() {
        }

        public Style(Image[] images, Color[] foregroundColor, Color[] backgroundColor, Font[] font) {
            this.images = images;
            this.foregroundColor = foregroundColor;
            this.backgroundColor = backgroundColor;
            this.font = font;
        }

        public Color[] getBackgroundColor() {
            return this.backgroundColor;
        }

        public List<RGBInformation> getBackgroundColorAsList() {
            return Style.convertColors(this.backgroundColor);
        }

        public List<RGBInformation> getForegroundColorAsList() {
            return Style.convertColors(this.foregroundColor);
        }

        private static List<RGBInformation> convertColors(Color[] colors) {
            ArrayList<RGBInformation> result = new ArrayList<RGBInformation>(colors.length);
            Color[] colorArray = colors;
            int n = colors.length;
            int n2 = 0;
            while (n2 < n) {
                Color color = colorArray[n2];
                if (color != null) {
                    result.add(new RGBInformation(color.getRGB()));
                } else {
                    result.add(null);
                }
                ++n2;
            }
            return result;
        }
    }
}

