/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.views;

import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.ae.ui.connection.data.MonitorStatusBean;
import org.eclipse.scada.core.Variant;

public class MonitorsLabelProvider
extends CellLabelProvider {
    private final IMapChangeListener mapChangeListener = new IMapChangeListener(){

        public void handleMapChange(MapChangeEvent event) {
            Set affectedElements = event.diff.getChangedKeys();
            if (!affectedElements.isEmpty()) {
                LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)MonitorsLabelProvider.this, affectedElements.toArray());
                MonitorsLabelProvider.this.fireLabelProviderChanged(newEvent);
            }
        }
    };
    private final IObservableMap[] attributeMaps;
    private final DateFormat dateFormat;

    public MonitorsLabelProvider(IObservableMap ... attributeMaps) {
        int i = 0;
        while (i < attributeMaps.length) {
            attributeMaps[i].addMapChangeListener(this.mapChangeListener);
            ++i;
        }
        this.attributeMaps = attributeMaps;
        this.dateFormat = DateFormat.getDateTimeInstance(1, 1);
    }

    public void dispose() {
        int i = 0;
        while (i < this.attributeMaps.length) {
            this.attributeMaps[i].removeMapChangeListener(this.mapChangeListener);
            ++i;
        }
        super.dispose();
    }

    public void update(ViewerCell cell) {
        Object o = cell.getElement();
        if (o instanceof MonitorStatusBean) {
            MonitorStatusBean info = (MonitorStatusBean)o;
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(info.getId());
                    break;
                }
                case 1: {
                    cell.setText(info.getStatus().toString());
                    break;
                }
                case 2: {
                    cell.setText(this.getTimestamp(info.getStatusTimestamp()));
                    break;
                }
                case 3: {
                    cell.setText(this.getAttribute(info.getAttributes(), "priority", "<none>"));
                    break;
                }
                case 4: {
                    cell.setText(this.getValue(info.getValue(), "<none>"));
                    break;
                }
                case 5: {
                    cell.setText(info.getLastAknUser() != null ? info.getLastAknUser() : "<unknown>");
                    break;
                }
                case 6: {
                    cell.setText(this.getTimestamp(info.getLastAknTimestamp()));
                    break;
                }
                case 7: {
                    cell.setText(this.getTimestamp(info.getLastFailTimestamp()));
                }
            }
        }
    }

    private String getTimestamp(Date timestamp) {
        if (timestamp != null) {
            return this.dateFormat.format(timestamp);
        }
        return "<none>";
    }

    private String getAttribute(Map<String, Variant> attributes, String key, String defaultString) {
        if (attributes == null) {
            return null;
        }
        return this.getValue(attributes.get(key), defaultString);
    }

    private String getValue(Variant value, String defaultString) {
        if (value == null) {
            return defaultString;
        }
        return value.asString(defaultString);
    }
}

