/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor.config;

import java.util.Map;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.scada.ca.ui.editor.config.AbstractConfigurationEditor;
import org.eclipse.scada.ca.ui.editor.config.ConfigurationCellLabelProvider;
import org.eclipse.scada.ca.ui.editor.config.EntryEditDialog;
import org.eclipse.scada.ui.databinding.AdapterHelper;
import org.eclipse.scada.ui.databinding.observable.ObservableMapContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public class BasicEditor
extends AbstractConfigurationEditor {
    public static final String EDITOR_ID = "org.eclipse.scada.ca.ui.connection.editors.BasicEditor";
    private TableViewer viewer;
    private final Action deleteAction = new Action("Delete"){

        public void run() {
            BasicEditor.this.handleDelete();
        }
    };

    public BasicEditor() {
        this(false);
    }

    public BasicEditor(boolean nested) {
        super(nested);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setPartName(input.toString());
        this.setSite((IWorkbenchPartSite)site);
        try {
            this.setInput(input);
        }
        catch (Exception e) {
            throw new PartInitException("Failed to initialize editor", (Throwable)e);
        }
    }

    @Override
    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.createViewer();
    }

    private void createViewer() {
        if (this.getEditorInput() != null && this.viewer != null) {
            this.viewer.setInput((Object)this.getEditorInput().getDataMap());
            this.viewer.setLabelProvider((IBaseLabelProvider)new ConfigurationCellLabelProvider(new IObservableMap[0]));
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 65538);
        TableLayout tableLayout = new TableLayout();
        this.viewer.getTable().setLayout((Layout)tableLayout);
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new ConfigurationCellLabelProvider(new IObservableMap[0]));
        col.getColumn().setText("Key");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        col = new TableViewerColumn(this.viewer, 0);
        col.setLabelProvider((CellLabelProvider)new ConfigurationCellLabelProvider(new IObservableMap[0]));
        col.getColumn().setText("Value");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ObservableMapContentProvider());
        this.createViewer();
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BasicEditor.this.triggerEditDialog(event.getSelection());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu(this.getEditorSite());
    }

    protected void triggerEditDialog(ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object o = ((IStructuredSelection)selection).getFirstElement();
        Map.Entry entry = (Map.Entry)AdapterHelper.adapt((Object)o, Map.Entry.class);
        if (entry == null) {
            return;
        }
        EntryEditDialog dlg = new EntryEditDialog(this.getSite().getShell(), entry);
        if (dlg.open() == 0) {
            this.updateEntry("" + entry.getKey(), dlg.getKey(), dlg.getValue());
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected void handleInsert() {
        EntryEditDialog dlg = new EntryEditDialog(this.getSite().getShell(), null);
        if (dlg.open() == 0) {
            this.insertEntry(dlg.getKey(), dlg.getValue());
        }
    }

    protected void handleDelete() {
        ISelection sel = this.viewer.getSelection();
        if (sel == null || sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        for (Object o : selection) {
            Map.Entry entry = (Map.Entry)AdapterHelper.adapt(o, Map.Entry.class);
            if (entry == null) continue;
            this.deleteEntry("" + entry.getKey());
        }
    }

    private void hookContextMenu(IEditorSite editorSite) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BasicEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        editorSite.registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.deleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void contribueTo(IEditorSite viewSite) {
        this.hookContextMenu(viewSite);
    }
}

