/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.data;

import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.connection.provider.ConnectionRequest;
import org.eclipse.scada.core.connection.provider.ConnectionRequestTracker;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.core.connection.provider.ConnectionTracker;
import org.eclipse.scada.hd.client.Connection;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.ui.data.AbstractQueryBuffer;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceQueryBuffer
extends AbstractQueryBuffer {
    private static final Logger logger = LoggerFactory.getLogger(ServiceQueryBuffer.class);
    private final ConnectionTracker tracker;
    private org.eclipse.scada.hd.connection.provider.ConnectionService connection;
    private final ConnectionTracker.Listener listener = new ConnectionTracker.Listener(){

        public void setConnection(ConnectionService connectionService) {
            ServiceQueryBuffer.this.setConnection(connectionService);
        }
    };
    private final ConnectionStateListener connectionStateListener = new ConnectionStateListener(){

        public void stateChange(org.eclipse.scada.core.client.Connection connection, ConnectionState state, Throwable error) {
            ServiceQueryBuffer.this.handleConnectionStateChange(connection, state, error);
        }
    };

    public ServiceQueryBuffer(BundleContext context, ConnectionRequest connectionRequest, String itemId, QueryParameters initialRequestParameters) {
        super(itemId);
        this.setRequestParameters(initialRequestParameters);
        this.tracker = new ConnectionRequestTracker(context, connectionRequest, this.listener, org.eclipse.scada.hd.connection.provider.ConnectionService.class);
    }

    public ServiceQueryBuffer(BundleContext context, String connectionId, String itemId, QueryParameters initialRequestParameters) {
        super(itemId);
        this.setRequestParameters(initialRequestParameters);
        this.tracker = new ConnectionIdTracker(context, connectionId, this.listener, org.eclipse.scada.hd.connection.provider.ConnectionService.class);
    }

    public void open() {
        this.tracker.open();
    }

    @Override
    public void close() {
        super.close();
        this.tracker.close();
        this.detachConnection();
    }

    protected void setConnection(ConnectionService connectionService) {
        logger.debug("Setting connection: {}", (Object)connectionService);
        this.detachConnection();
        if (connectionService != null) {
            this.attachConnection(connectionService);
        }
    }

    private void attachConnection(ConnectionService connectionService) {
        if (connectionService == null) {
            return;
        }
        if (!(connectionService instanceof org.eclipse.scada.hd.connection.provider.ConnectionService)) {
            return;
        }
        this.connection = (org.eclipse.scada.hd.connection.provider.ConnectionService)connectionService;
        this.connection.getConnection().addConnectionStateListener(this.connectionStateListener);
        Connection c = this.connection.getConnection();
        this.handleConnectionStateChange((org.eclipse.scada.core.client.Connection)c, c.getState(), null);
    }

    private void detachConnection() {
        if (this.connection == null) {
            return;
        }
        this.connection.getConnection().removeConnectionStateListener(this.connectionStateListener);
        this.connection = null;
    }

    protected void handleConnectionStateChange(org.eclipse.scada.core.client.Connection connection, ConnectionState state, Throwable error) {
        logger.debug("Handle connection state change - connection: {}, state: {}", (Object)connection, (Object)state);
        if (state == ConnectionState.BOUND) {
            this.createQuery(this.connection.getConnection(), this.itemId);
        } else {
            this.closeQuery();
        }
    }
}

